/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

package com.sun.enterprise.admin.monitor.stats;
import javax.management.j2ee.statistics.CountStatistic;
import javax.management.j2ee.statistics.TimeStatistic;
import com.sun.enterprise.admin.monitor.stats.AverageRangeStatistic;

/**
 *
 * @since 8.1
 */
public interface HAStatefulSessionStoreStats extends StatefulSessionStoreStats {
    
    /**
     * Returns the total number of sessions checkpointed using this store
     * @return CountStatistic
     */
    public CountStatistic getCheckpointCount();
    
    /**
     * Returns the total number of sessions successfully checkpointed using
     * this store
     * @return CountStatistic
     */
    public CountStatistic getCheckpointSuccessCount();
    
    /**
     * Returns the total number of sessions that could not be checkpointed
     * using this store
     * @return CountStatistic
     */
    public CountStatistic getCheckpointErrorCount();
    
    /**
     * Returns the total number of bytes checkpointed by the store
     * @return AverageRangeStatistic
     */
    public AverageRangeStatistic getCheckpointedBeanSize();
    
    /**
     * Returns the time spent on checkpointing beans to the store
     * @return AverageRangeStatistic
     */
    public AverageRangeStatistic getCheckpointTime();
    
}
