/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

/*
 * $Id: OrbConnectionManagerStats.java,v 1.2 2005/12/25 03:52:20 tcfujii Exp $
 * $Date: 2005/12/25 03:52:20 $
 * $Revision: 1.2 $
 */

package com.sun.enterprise.admin.monitor.stats;
import javax.management.j2ee.statistics.Stats;
import javax.management.j2ee.statistics.CountStatistic;
import javax.management.j2ee.statistics.BoundedRangeStatistic;

/**
 * Stats interface for the monitorable attributes of the
 * ORBConnectionManager
 * This combines the statistics that were exposed in 7.0
 * with the new ones.
 */
public interface OrbConnectionManagerStats extends Stats {
    
    /** Returns the total number of connections to the ORB as an instance of BoundedRangeStatistic.
	 * @return		an instance of {@link BoundedRangeStatistic}     
	 */
    public BoundedRangeStatistic getTotalConnections();
    
    /** Returns the total number of idle connections to the ORB as an instance of CountStatistic.
	 * @return		an instance of {@link CountStatistic}     
	 */
    public CountStatistic getConnectionsIdle();
    
    /** Returns the total number of in-use connections to the ORB as an instance of CountStatistic.
	 * @return		an instance of {@link CountStatistic}     
	 */
    public CountStatistic getConnectionsInUse();   
}
