/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.management.support;


import java.util.Map;
import java.util.HashMap;
import java.util.Collections;

/**
    See also com.sun.enterprise.management.support.SystemInfoImpl
    
    @see com.sun.appserv.management.base.SystemInfo
    @see com.sun.enterprise.management.support.SystemInfoImpl
 */
public final class SystemInfoData {
    private static final SystemInfoData INSTANCE = new SystemInfoData();
    
    private final Map<String,Long>      mPerformanceMillis;
    private final Map<String,Long>      mUnmodifiablePerformanceMillis;
    
    private SystemInfoData() {
        mPerformanceMillis  = Collections.synchronizedMap( new HashMap<String,Long>() );
        mUnmodifiablePerformanceMillis  = Collections.unmodifiableMap( mPerformanceMillis );
    }
    
        public static SystemInfoData
    getInstance() {
        return INSTANCE;
    }
    
    /**
        Add a performance metric.
     */
        public synchronized void
    addPerformanceMillis( final String name, final long millis ) {
        if ( mPerformanceMillis.containsKey( name ) ) {
            throw new IllegalStateException();
        }
        mPerformanceMillis.put( name, millis );
    }
    
    /**
       @return unmodifiable Map of performance data
     */
        public Map<String,Long>
    getPerformanceMillis() {
        return mUnmodifiablePerformanceMillis;
    }
}

