/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

/*
 * TokenValueCollection.java
 *
 * Created on March 6, 2003, 12:00 PM
 */

package com.sun.enterprise.admin.util;

import java.util.Iterator;
import java.util.Set;
import java.util.HashSet;
import com.sun.enterprise.admin.util.TokenValue;

/**
 *
 * @author  kedar
 */

public class TokenValueSet implements Cloneable {
    
    /** Creates a new instance of TokenValueSet */
    private final Set values;
    
    public TokenValueSet() {
        values = new HashSet();
    }
    
    public TokenValueSet(Set values) {
        //if (!isTokenValueSet(values)) {
          //  throw new IllegalArgumentException("Invalid set");
        //}
        this.values = new HashSet();
        this.values.addAll(values);
    }
    
    public void add(TokenValue tokenValue) {
        boolean added = this.values.add(tokenValue);
    }
    
    public void remove(TokenValue tokenValue) {
        this.values.remove(tokenValue);
    }
    
    public void clear() {
        this.values.clear();
    }
    
    public Iterator iterator() {
        return ( this.values.iterator() );
    }
    
    public boolean isEmpty() {
        return ( this.values.isEmpty() );
    }
    
    public Object[] toArray() {
        return ( this.values.toArray() );
    }
    
    public int size() {
        return ( this.values.size() );
    }
    
    public Object clone() throws CloneNotSupportedException {
        return ( super.clone() );
    }
    
    public String toString() {
        StringBuffer buf = new StringBuffer();
        Iterator iter = this.iterator();
        while(iter.hasNext()) {
            TokenValue tv = (TokenValue) iter.next();
            buf.append(tv.toString());
            buf.append(System.getProperty("line.separator"));
        }
        return ( buf.toString() );
    }
}
