/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

/*
 * TokenReplacementTester.java
 *
 * Created on March 6, 2003, 5:11 PM
 */

package com.sun.enterprise.admin.util.test;

import com.sun.enterprise.admin.util.LineTokenReplacer;
import com.sun.enterprise.admin.util.TokenValue;
import com.sun.enterprise.admin.util.TokenValueSet;

import java.io.File;
import java.io.FileReader;
import java.io.BufferedReader;
import java.util.StringTokenizer;

/**
 *
 * @author  kedar
 */
public class TokenReplacementTester {
    
    /** Creates a new instance of TokenReplacementTester */
    private final LineTokenReplacer replacer;
    
    public TokenReplacementTester(String tokensFileName, String fromFile, String toFile) {
        final TokenValueSet tokens = getTokensFromFile(tokensFileName);
        replacer = new LineTokenReplacer(tokens);
        replacer.replace(fromFile, toFile);
    }
    
    private TokenValueSet getTokensFromFile(String fileName) {
        final TokenValueSet tokens  = new TokenValueSet();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(fileName));
            String line = null;
            while ((line = reader.readLine()) != null) {
                final TokenValue tv = getTokenValue(line);
                tokens.add(tv);
            }
            reader.close();
            reader = null;
        }
        catch(Exception e) {
            e.printStackTrace();
            if (reader != null) {
                try {
                    reader.close();
                } catch (Exception ex) {}
            }
        } 
        return tokens;
    } 

    private TokenValue getTokenValue(String line) {
        final String delim = "=";
        final StringTokenizer parser = new StringTokenizer(line, delim);
        final String[] output = new String[2];
        int i = 0;
        while(parser.hasMoreTokens()) {
            output[i++] = parser.nextToken();
        }
        final String DELIM = "%%%";
        TokenValue tv = new TokenValue(output[0], output[1], DELIM);
        return ( tv );
    }
    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        int length = args.length;
        if (length < 2) {
            usage();
            System.exit(1);
        }
        final String tokensFile = args[0];
        final String fromFile = args[1];
        final String toFile = fromFile + ".out";
        new TokenReplacementTester(tokensFile, fromFile, toFile);
    }
    
    private static void usage() {
        System.out.println("java TokenReplacementTester <tokens-file> <template-file>");
    }
}
