/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
package com.sun.enterprise.management.config;

import java.util.Set;
import java.util.Map;
import com.sun.appserv.management.util.misc.MapUtil;
import javax.management.AttributeList;

import javax.management.ObjectName;

import com.sun.appserv.management.util.misc.GSetUtil;
import com.sun.appserv.management.config.ClusterRefConfigCR;
import com.sun.enterprise.management.support.oldconfig.OldClusterMBean;
import com.sun.enterprise.management.support.oldconfig.OldLbConfig;

final class ClusterRefConfigFactory extends ConfigFactory {
	
    private final OldLbConfig mOldLbConfigMBean;
    
    private final Set<String>	LEGAL_OPTIONAL_KEYS = 
        GSetUtil.newUnmodifiableStringSet(
            ClusterRefConfigCR.LB_POLICY_KEY,
            ClusterRefConfigCR.LB_POLICY_MODULE_KEY );

    protected Map<String,String> getParamNameOverrides() {
        return(MapUtil.newMap(CONFIG_NAME_KEY, "ref"));
    }

    protected Set<String> getLegalOptionalCreateKeys() {
        return(LEGAL_OPTIONAL_KEYS);
    }

    public ClusterRefConfigFactory(final ConfigFactoryCallback callbacks) {
        super(callbacks);
        final String containerName = getFactoryContainer().getName();
        mOldLbConfigMBean = getOldConfigProxies().getOldLbConfig(containerName);
    }
        
    protected ObjectName createOldChildConfig(final AttributeList translatedAttrs) {
        return mOldLbConfigMBean.createClusterRef(translatedAttrs);
    }

    public ObjectName create(final String referencedClusterName, 
        final Map<String,String> optional) {

        final String[] requiredParams = new String[] {};
        final Map<String,String> params = initParams(referencedClusterName, requiredParams, optional);
        final ObjectName amxName = createNamedChild(referencedClusterName, params);
        return(amxName);                
    }

    public ObjectName create(final String referencedClusterName, 
        final String lbPolicy, final String lbPolicyModule) {

        final Map<String,String> optionalParams = new java.util.HashMap<String,String>();
        if (lbPolicy != null)
            optionalParams.put(ClusterRefConfigCR.LB_POLICY_KEY,lbPolicy); 
        if (lbPolicyModule != null)
            optionalParams.put(ClusterRefConfigCR.LB_POLICY_MODULE_KEY, lbPolicyModule); 

        return create(referencedClusterName, optionalParams);
    }

    public void removeByName(final String referencedClusterName)	{
        mOldLbConfigMBean.removeClusterRefByRef(referencedClusterName);
    }
}