/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin/mbeanapi-impl/src/java/com/sun/enterprise/management/config/HTTPFileCacheConfigFactory.java,v 1.4 2006/03/09 20:30:38 llc Exp $
 * $Revision: 1.4 $
 * $Date: 2006/03/09 20:30:38 $
 */
package com.sun.enterprise.management.config;

import java.util.Map;
import java.util.Set;
import java.util.Collections;

import javax.management.ObjectName;
import javax.management.AttributeList;

import com.sun.enterprise.management.support.oldconfig.OldHTTPServiceMBean;

import com.sun.appserv.management.util.misc.GSetUtil;
import com.sun.appserv.management.config.HTTPFileCacheConfigKeys;


final class HTTPFileCacheConfigFactory extends ConfigFactory
{
	private final OldHTTPServiceMBean	mOldHTTPServiceMBean;
	
		public
	HTTPFileCacheConfigFactory( final ConfigFactoryCallback	callbacks )
	{
		super( callbacks );
		
		mOldHTTPServiceMBean	=
			getOldConfigProxies().getOldHTTPServiceMBean( getConfigName() );
	}
	
	private final Set<String>	LEGAL_OPTIONAL_KEYS	= 
		GSetUtil.newUnmodifiableStringSet(
		HTTPFileCacheConfigKeys.GLOBALLY_ENABLED_KEY,
		HTTPFileCacheConfigKeys.FILE_CACHING_ENABLED_KEY,
		HTTPFileCacheConfigKeys.MAX_AGE_IN_SECONDS_KEY,
		HTTPFileCacheConfigKeys.MEDIUM_FILE_SIZE_LIMIT_IN_BYTES_KEY,
		HTTPFileCacheConfigKeys.MEDIUM_FILE_SPACE_IN_BYTES_KEY,
		HTTPFileCacheConfigKeys.SMALL_FILE_SIZE_LIMIT_IN_BYTES_KEY,
		HTTPFileCacheConfigKeys.SMALL_FILE_SPACE_IN_BYTES_KEY,
		HTTPFileCacheConfigKeys.FILE_TRANSMISSION_ENABLED_KEY,
		HTTPFileCacheConfigKeys.MAX_FILES_COUNT_KEY,
		HTTPFileCacheConfigKeys.HASH_INIT_SIZE_KEY );
	
	    protected Set<String>
	getLegalOptionalCreateKeys()
	{
		return( LEGAL_OPTIONAL_KEYS );
	}
	
		public ObjectName	
	create( final Map<String,String> optional )
	{
		final Map<String,String>	params	= initParams( optional );

		final ObjectName	amxName	= createChild( params );
		
		return( amxName );
	}

		protected void	
	internalRemove( final ObjectName objectName )
	{
		mOldHTTPServiceMBean.removeHttpFileCache();
	}

		protected ObjectName
	createOldChildConfig( AttributeList attrs )
	{
		return mOldHTTPServiceMBean.createHttpFileCache( attrs );
	}
}




