/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.management.config;

import java.util.Map;
import java.util.Set;
import java.util.Collections;

import javax.management.ObjectName;
import javax.management.AttributeList;

import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.config.AMXConfig;
import com.sun.appserv.management.config.ProviderConfig;
import com.sun.appserv.management.util.misc.MapUtil;
import com.sun.enterprise.management.support.oldconfig.OldSecurityServiceMBean;
import com.sun.enterprise.management.support.oldconfig.OldConfigsMBean;

import com.sun.appserv.management.util.misc.GSetUtil;
import com.sun.appserv.management.util.jmx.JMXUtil;


import com.sun.appserv.management.config.MessageSecurityConfigKeys;

/**
 */
public final class MessageSecurityConfigFactory extends ConfigFactory 
{
	private final OldSecurityServiceMBean	mOldSecurityServiceMBean;
	private final OldConfigsMBean           mOldConfigs;
	
		public
	MessageSecurityConfigFactory( final ConfigFactoryCallback callbacks )
	{
		super( callbacks );
		
		mOldSecurityServiceMBean	=
			getOldConfigProxies().getOldSecurityServiceMBean( getConfigName() );
        
        mOldConfigs = getOldConfigProxies().getOldConfigsMBean();
	}
    
		public ObjectName	
    create(
        final String  authLayer,
        final String  providerID,
        final String  providerType, 
	    final String  providerClassname,
        Map<String,String>  optional )
	{
        final String requestAuthSource  = null;
        final String requestAuthRecipient  = null;
        final String responseAuthSource  = null;
        final String responseAuthRecipient  = null;
        final boolean   isDefaultProvider   = false;
        final java.util.Properties props  = null;
        final String targetName = getConfigName();
        
        final ObjectName provider = mOldConfigs.createMessageSecurityProvider(
            authLayer,
            providerID,
            providerType,
            providerClassname,
            requestAuthSource,
            requestAuthRecipient,
            responseAuthSource,
            responseAuthRecipient,
            isDefaultProvider,
            props,
            targetName
            );
        // the resulting MBean is the *provider*, NOT the type=message-security mbean
        getLogger().info( "OBJECTNAME: " + JMXUtil.toString( provider ) );
        
        final ObjectName providerObjectName = finish( provider, null );
        final ProviderConfig providerConfig = (ProviderConfig)
            Util.getExtra(getFactoryContainer()).getProxyFactory().getProxy( providerObjectName );
        
		final ObjectName amxName = Util.getExtra(providerConfig.getContainer()).getObjectName();
        
		return amxName;
	}


		protected final void		
	removeByName( final String authLayer )
	{
		mOldSecurityServiceMBean.removeMessageSecurityConfigByAuthLayer( authLayer );
	}
}






