/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.management.config;

import javax.management.ObjectName;

import com.sun.appserv.management.base.DottedNames;
import com.sun.appserv.management.base.XTypes;
import com.sun.appserv.management.config.ConfigDottedNames;

import com.sun.enterprise.management.support.DottedNamesBase;
import com.sun.enterprise.management.offline.OfflineDottedNamesMgr;

/**
    Supports 'asadmin' dotted names when AMX is loaded in
    Offline mode.
    @see com.sun.appserv.management.config.OfflineConfigIniter
 */
public final class OfflineConfigDottedNamesImpl  extends DottedNamesBase
    implements DottedNames
{
    private OfflineDottedNamesMgr mMgr;
    
		public
	OfflineConfigDottedNamesImpl()
	{
	    mMgr    = null;
	    throw new RuntimeException( "Not fully implemented" );
	}
	
		protected Class
	getInterface( final String j2eeType )
	{
		return ConfigDottedNames.class;
	}
	
	    public void
	preRegisterDone()
	{
	    mMgr    = new OfflineDottedNamesMgr( getMBeanServer() );
	}
	
        protected void 
    setupOldDottedNamesProxy()
    {
        mOldDottedNamesProxy    = null;
    }

		protected String
	deduceJ2EEType( final Class c)
	{
	    return XTypes.CONFIG_DOTTED_NAMES;
	}
	
		public String
	getGroup()
	{
		return( GROUP_CONFIGURATION );
	}
	
		public Object[]
	dottedNameGet( final String[] names )
	{
	    return mMgr.dottedNameGet( names );
	}
	
		public Object
	dottedNameGet( final String dottedName )
	{
	    return mMgr.dottedNameGet( dottedName );
	}
	
		public Object[]
	dottedNameList( final String[] dottedNames )
	{
	    return mMgr.dottedNameList( dottedNames );
	}
	
		public Object[]
	dottedNameSet( final String[] nameValuePairs )
	{
	    return mMgr.dottedNameSet( nameValuePairs );
	}
	
		protected boolean
	isWriteableDottedName( String name )
	{
		return( true );
	}
}

