/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.management.config;

import java.util.Map;

import javax.management.ObjectName;

import com.sun.appserv.management.base.Util;

import com.sun.appserv.management.config.MessageSecurityConfig;
import com.sun.appserv.management.config.SecurityServiceConfig;
import com.sun.appserv.management.config.ProviderConfig;

import com.sun.appserv.management.util.misc.MapUtil;
import com.sun.enterprise.management.support.oldconfig.OldSecurityServiceMBean;
import com.sun.enterprise.management.support.oldconfig.OldMessageSecurityConfigMBean;

/**
 */
public final class ProviderConfigFactory extends ConfigFactory 
	// implements ProviderConfigMgr
{
	private final OldSecurityServiceMBean       mOldSecurityServiceMBean;
	private final OldMessageSecurityConfigMBean	mOldMessageSecurityConfigMBean;
	
	public ProviderConfigFactory(final ConfigFactoryCallback	callbacks)
	{
		super( callbacks );
		
        // the type=message-security MBean just doesn't work; we must use
        // the type=security-service MBean instead.
		mOldSecurityServiceMBean	=
			getOldConfigProxies().getOldSecurityServiceMBean( getConfigName() );
		
		mOldMessageSecurityConfigMBean   = getOldMessageSecurityConfigMBean();
	}
	
		private final OldMessageSecurityConfigMBean
	getOldMessageSecurityConfigMBean()
	{
		final String name   = getFactoryContainer().getName();
		return getOldConfigProxies().getOldMessageSecurityConfigMBean( name );
	}


    /**
        The underlying API is function-oriented mess. We actually have to "create" a new
        message security (which might already exist) in order to create a provider-config.
        This is a special-case compared to all the other ones.
     */
		public ObjectName	
    create(
		final String    name,
		final String    providerType, 
		final String    providerClassname,
        Map<String,String>  optional )
	{
        final MessageSecurityConfig msc = (MessageSecurityConfig)getFactoryContainer();
        final SecurityServiceConfig ss  = (SecurityServiceConfig)(msc.getContainer());
        
        final MessageSecurityConfig newMSC  = 
            ss.createMessageSecurityConfig( msc.getAuthLayer(), name, providerType, providerClassname, optional );
        // 'newMSC' and 'msc' should be the same.
        
        final ProviderConfig providerConfig = newMSC.getProviderConfigMap().get( name );
        
		return Util.getObjectName( providerConfig );
	}


		protected final void
	removeByName(final String name)
	{
		getOldMessageSecurityConfigMBean().removeProviderConfigByProviderId( name );
	}
}

















