/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.management.config;

import java.util.Map;
import java.util.HashMap;
import java.util.Set;
import java.io.File;

import javax.management.ObjectName;
import javax.management.AttributeList;

import com.sun.appserv.management.config.TransformationRuleConfig;
import com.sun.appserv.management.config.TransformationRuleConfigKeys;
import com.sun.appserv.management.util.misc.GSetUtil;
import com.sun.appserv.management.base.Util;
import com.sun.enterprise.management.support.oldconfig.OldWebServiceEndpointConfigMBean;
import com.sun.enterprise.admin.wsmgmt.WebServiceMgrBackEnd;

import javax.xml.transform.stream.StreamSource;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.Transformer;

public final class TransformationRuleConfigFactory  extends ConfigFactory
{

    private final OldWebServiceEndpointConfigMBean
        mOldWebServiceEndpointConfigMBean;

    private TransformerFactory _tFactory;
    
public
	TransformationRuleConfigFactory(
		final ConfigFactoryCallback callbacks )
	{
		super( callbacks );

         _tFactory = TransformerFactory.newInstance();

        mOldWebServiceEndpointConfigMBean =
        getOldWebServiceEndpointConfigMBean();
	}

    private final OldWebServiceEndpointConfigMBean
    getOldWebServiceEndpointConfigMBean() 
    {
        final String name   = getFactoryContainer().getName();
		return getOldConfigProxies().getOldWebServiceEndpointConfigMBean( name );

    }
                
  /**
		The caller is responsible for dealing with any Properties.
	 */
		protected ObjectName
	createOldChildConfig(
		final AttributeList translatedAttrs )
	{
            final ObjectName oldObjectName = (ObjectName)
	        getCallbacks().getDelegate().invoke(
	            CREATE_TRANSFORMATION_RULE, new Object[] { translatedAttrs }, 
                CREATE_TRANSFORMATION_RULE_SIG );
		
		return oldObjectName;

	}
          
		public ObjectName
	create(
        final String    name,
        final String    ruleFileLocation,
        final boolean   enabled, 
        final String   applyTo, 
        final Map<String,String> reserved  )
	{

         String appId = getFactoryContainer().getContainer().getName(); 

         String finalRuleFileLocation = null;
         
         try {
             StreamSource stylesource =
                   new StreamSource(new File(ruleFileLocation));
            Transformer transformer = _tFactory.newTransformer(stylesource);

             finalRuleFileLocation = WebServiceMgrBackEnd.getManager().
                moveFileToRepository(ruleFileLocation, appId);
        } catch (Throwable t) {
            throw new RuntimeException(t);
        }
         
         Map<String,String>  optional = new HashMap<String,String>();
         optional.put(TransformationRuleConfigKeys.ENABLED_KEY,
         Boolean.toString(enabled));
         optional.put(TransformationRuleConfigKeys.APPLY_TO_KEY, applyTo);
         final String[] requiredParams = new String[] {
            TransformationRuleConfigKeys.RULE_FILE_LOCATION_KEY,
            finalRuleFileLocation };

        if (reserved != null) {
            optional.putAll(reserved);
        }

        final Map<String,String> params = initParams(name, requiredParams, optional);

        trace( "params as processed: " + stringify( params ) );

		final ObjectName	amxName	= createChild( params );
		
		return( amxName );
    }

        protected final void
	removeByName(String name)
	{
        String appId = getFactoryContainer().getContainer().getName(); 
        String epName = getFactoryContainer().getName(); 
        WebServiceMgrBackEnd.getManager().
                removeFileFromRepository(appId,epName,name);
		mOldWebServiceEndpointConfigMBean.removeTransformationRuleByName(name);
	}


	private final Set<String>	LEGAL_OPTIONAL_KEYS	= 
		GSetUtil.newUnmodifiableStringSet(
		TransformationRuleConfigKeys.ENABLED_KEY,
		TransformationRuleConfigKeys.APPLY_TO_KEY);
	
	    protected Set<String>
	getLegalOptionalCreateKeys()
	{
		return( LEGAL_OPTIONAL_KEYS );
	}

    private static final String CREATE_TRANSFORMATION_RULE  =
            "createTransformationRule";
    private static final String[] CREATE_TRANSFORMATION_RULE_SIG  = 
            new String[] { AttributeList.class.getName() };
    private static final String REMOVE_TRANSFORMATION_RULE  =
            "removeTransformationRuleByName";
    private static final String[] REMOVE_TRANSFORMATION_RULE_SIG  = 
            new String[] { String.class.getName() };

}





