/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */
 
/*
 */

package com.sun.enterprise.management.support;


/**
    This interface will be exposed in MBeanInfo when AMX-DEBUG.enabled=true.
    It is private and should be used only for internal development purposes.
    @see com.sun.appserv.management.base.AMXDebug
 */
public interface AMXDebugStuff
{
    /**
        Applicable to those MBeans that have a Delegate.
        Output any anomolies between the interface the MBean
        provides and the items that are available in the Delegate.
        <p>
        If debug is off, or there is no Delegate, then null is returned.
        If there are no issues, then an empty String is returned.
        Otherwise, a String describing the problem(s) is returned.
        
        @return a String summary
     */
    public String checkInterfaceAgainstDelegate();
    
    /**
     */
    public boolean getAMXDebug();
    
    /**
        Implemented as a method, so it can be used with or without
        AMX-DEBUG being on (unknown Attributes are rejected normally).
        @return previous enable status
     */
    public boolean enableAMXDebug( final boolean enable );
    
    
    /**
        Implemented as a method, so it can be used with or without
        AMX-DEBUG being on (unknown Attributes are rejected normally).
        @return previous enable status
     */
    public boolean enableCoverageInfo( final boolean enable );
    
    /**
        This is only for internal, debug use, so it's OK
        to return a proprietary type.
     */
    public CoverageInfo getCoverageInfo();
    
    
    /**
        This is only for internal, debug use, so it's OK
        to return a proprietary type.
     */
    public void clearCoverageInfo();
    
    /**
        Produces a useful String describing the AMX MBean.
     */
    public String   getImplString( boolean verbose );
}

