/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.management.support;

import java.util.Map;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.HashSet;
import java.util.HashMap;
import java.util.ArrayList;

import javax.management.ObjectName;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanOperationInfo;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeChangeNotification;
import javax.management.InstanceNotFoundException;
import javax.management.ReflectionException;
import javax.management.MBeanException;
import javax.management.IntrospectionException;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;

import javax.management.MBeanServerInvocationHandler;



import com.sun.appserv.management.util.misc.ClassUtil;
import com.sun.appserv.management.util.misc.GSetUtil;
import com.sun.appserv.management.util.jmx.JMXUtil;

import com.sun.appserv.management.config.PropertiesAccess;
import com.sun.appserv.management.base.XTypesMapper;
import com.sun.appserv.management.base.Util;

import com.sun.appserv.management.base.DottedNames;
import com.sun.appserv.management.base.AMX;

import com.sun.enterprise.management.support.ObjectNames;



/**
	Base class from which the DottedNames (config and monitoring) MBeans
	inherit.
	<p>
 */
public abstract class DottedNamesBase extends AMXImplBase
	implements DottedNames
{
	private static final String	DOTTED_NAMES	=
		"com.sun.appserv:name=dotted-name-get-set,type=dotted-name-support";
	
	protected OldDottedNamesProxy	mOldDottedNamesProxy	= null;
	
	private MBeanInfo	mMBeanInfo;
	private Map<String,Attribute>			mAttributes;
	
	private Set<String>			mParentAttributeNames;
	
		public
	DottedNamesBase()
	{
		mMBeanInfo	= null;
		
		mParentAttributeNames	= null;
	}
	
	
	public abstract Object[]	dottedNameGet( String[] names );
	public abstract Object		dottedNameGet( String name );
	public abstract Object[]	dottedNameList( String[] names );
	public abstract Object[]	dottedNameSet( String[] nameValuePairs );
	
	protected abstract boolean		isWriteableDottedName( String name );

	
	/**
		MBeanInfo Attributes change whenever the dotted-namespace changes.
	 */
		public boolean
	getMBeanInfoIsInvariant()
	{
		return( false );
	}
	
	/**
		Note the during registration, we won't have setup our delegate, and our
		MBeanInfo will therefore not contain any Attributes.
	 */
		public MBeanInfo
	getMBeanInfo()
	{
		MBeanInfo	mbeanInfo	= null;
		
		if ( getOldDottedNames() != null )
		{
			ensureMBeanInfo();
			mbeanInfo	= mMBeanInfo;
		}
		else
		{
			mbeanInfo	= super.getMBeanInfo();
		}
		
		return( mbeanInfo );
	}
	
		public void
	preRegisterDone()
		throws Exception
	{
	    super.preRegisterDone();
	    
		setupOldDottedNamesProxy( );
	}
	
	
	/**
		Proxy representing the "old" DottedNames
 	*/
	protected interface OldDottedNamesProxy
	{
		public Object[]	dottedNameGet( String[] names );
		public Object	dottedNameGet( String name );
		public Object[]	dottedNameMonitoringGet( String[] names );
		public Object	dottedNameMonitoringGet( String names );
		public String[]	dottedNameList( String[] names );
		public String[]	dottedNameMonitoringList( String[] names );
		public Object[]	dottedNameSet( String[] names );
	}

		protected void
	setupOldDottedNamesProxy( )
	{
		setupOldDottedNamesProxy( Util.newObjectName( DOTTED_NAMES ) );
	}

		protected void
	setupOldDottedNamesProxy( ObjectName target )
	{
		final MBeanServer	server	= getMBeanServer();
		
		if ( ! server.isRegistered( target ) )
		{
		logSevere( "setupOldDottedNamesProxy: old dotted names MBeans is not registered" );
		}
		
		mOldDottedNamesProxy	= (OldDottedNamesProxy)
			MBeanServerInvocationHandler.newProxyInstance(
				server, target, OldDottedNamesProxy.class, false );
	}
	
		protected OldDottedNamesProxy
	getOldDottedNames()
	{
		return( mOldDottedNamesProxy );
	}
	
		protected final boolean
	isDottedName( final String name )
	{
		return( getAttributes().keySet().contains( name ) );
	}
	
		protected final boolean
	isParentAttributeName( final String name )
	{
		return( mParentAttributeNames.contains( name ) );
	}
	
		protected final void
	filterNames(
		final String[]	in,
		Set<String>		dotted,
		Set<String>		parent )
	{
		for( int i = 0; i < in.length; ++i )
		{
			final String	name	= in[ i ];
			
			if ( isDottedName( name ) )
			{
				dotted.add( name );
			}
			else if ( isParentAttributeName( name ) )
			{
				parent.add( name );
			}
		}
	}
	
		public AttributeList
	getAttributes( final String[]	names )
	{
    	mCoverage.attributesWereRead( names );
	    
		final Set<String>	dotted	= new HashSet<String>();
		final Set<String>	parent	= new HashSet<String>();
		filterNames( names, dotted, parent);

		final Object[]	dottedResults	=
			dottedNameGet( (String[])dotted.toArray( new String[ dotted.size() ] ) );
		
		final String[]		namesForParent	= new String[ parent.size() ];
		final AttributeList	parentResults	=
			super.getAttributes( (String[])parent.toArray( namesForParent ) );
		
		final AttributeList	successList	= new AttributeList();
		successList.addAll( parentResults );
		
		// add all the dotted name results
		for( int i = 0; i < dottedResults.length; ++i )
		{
			if ( dottedResults[ i ] instanceof Attribute )
			{
				successList.add( (Attribute)dottedResults[ i ] );
			}
			else
			{
				assert( dottedResults[ i ] instanceof Exception );
			}
		}
		
		
		return( successList );
	}
	
		public Object
	getAttribute( final String	name )
		throws AttributeNotFoundException
	{
		checkLegalName( name );
	    mCoverage.attributeWasRead( name );
		
		Object	result	= null;
		
		if ( isDottedName( name ) )
		{
			result	= dottedNameGet( name );
			assert( !(result instanceof Attribute) );
		}
		else if ( isParentAttributeName( name ) )
		{
			result	= super.getAttribute( name );
		}
		else
		{
			throw new AttributeNotFoundException( name );
		}
		
		return( result );
	}
	
	
		public void
	setAttribute( final Attribute attr )
		throws AttributeNotFoundException, InvalidAttributeValueException
	{
	    final String    name    = attr.getName();
	    
	    if ( isParentAttributeName( name ) )
	    {
	        super.setAttribute( attr );
	    }
	    else
	    {
    		checkLegalName( name );
    	    mCoverage.attributeWasWritten( name );
    		
    		final AttributeList		inList	= new AttributeList();
    		inList.add( attr );
    		final AttributeList	result	= setAttributes( inList );
    		if ( result.size() != 1)
    		{
    			throw new InvalidAttributeValueException( attr.getName() );
    		}
		}
	}
	
		public AttributeList
	setAttributes( AttributeList attributes )
	{
    	
		/*
			Convert each attribute to a name/value pair.
			Omit any attributes that don't have a legal attribute name
		 */
		final int	numAttrsIn	= attributes.size();
		final List<String>	legalPairs	= new ArrayList<String>();
		for( int i = 0; i < numAttrsIn; ++i )
		{
			final Attribute	attr	= (Attribute)attributes.get( i );
			
			final String    name    = attr.getName();
			mCoverage.attributeWasWritten( name );
			
			if ( isLegalAttributeName( name ) )
			{
				legalPairs.add( attributeToNamePair( attr ) );
			}
		}
		
		final String[]	pairs	= (String[])legalPairs.toArray( new String[ legalPairs.size() ] );

		final Object[] results	= dottedNameSet( pairs );
		
		final AttributeList	attributeList	= new AttributeList();
		for( int i = 0; i < results.length; ++i )
		{
			if ( results[ i ] instanceof Attribute )
			{
				attributeList.add( (Attribute)results[ i ] );
			}
			else
			{
				assert( results[ i ] instanceof Exception );
				// it's an exception
			}
		}
		
		return( attributeList );
	}
	
	
		public Object
	invokeManually(
		String		operationName,
		Object[]	params,
		String[]	types)
		throws ReflectionException, MBeanException, NoSuchMethodException,
		AttributeNotFoundException
	{
		final boolean	noParams	= params == null || params.length == 0;
		Object			result	= null;
		
		if ( operationName.equals( "refresh" ) && noParams )
		{
			refresh();
			result	= null;
		}
		else
		{
			result	= super.invokeManually( operationName, params, types );
		}
		return( result );
	}
	
		private synchronized void
	ensureMBeanInfo()
	{
		if ( mMBeanInfo == null )
		{
			trace( "##### DottedNamesBase.ensureMBeanInfo" );
			refresh();
			assert( mMBeanInfo != null );
		}
	}
	
	
		protected MBeanAttributeInfo[]
	buildAttributeInfos( final MBeanAttributeInfo[] parentAttributeInfos )
	{
		final String[]	parentAttributeNames	=
			JMXUtil.getAttributeNames( parentAttributeInfos );
		mParentAttributeNames	=
		    GSetUtil.newUnmodifiableStringSet( parentAttributeNames );
		
		final Map<String,Attribute>		attributes	=	getAttributes();
		
		final MBeanAttributeInfo[]	infos =
			new MBeanAttributeInfo[ attributes.size()  + parentAttributeInfos.length ];
		
		// make info for every Attribute
		
		int i	= 0;
		for( final String name : attributes.keySet() )
		{
			final Attribute	attr	= attributes.get( name );
		
			final Object	value	= attr.getValue();
			final Class	theClass	= value == null ? String.class : attr.getValue().getClass();
			
			infos[ i ]	= new MBeanAttributeInfo( name, theClass.getName(), "",
				true, isWriteableDottedName( name ), false );
			++i;
		}
		
		System.arraycopy( parentAttributeInfos, 0,
			infos, attributes.size(), parentAttributeInfos.length );

		return( infos );
	}
	
		protected MBeanOperationInfo[]
	buildOperationInfos( final MBeanOperationInfo[] existing )
	{
		final MBeanOperationInfo	refreshInfo	= new MBeanOperationInfo( "refresh",
			"update MBeanInfo to reflect all available dotted names",
			null,
			Void.class.getName(),
			MBeanOperationInfo.ACTION );
		
		final MBeanOperationInfo[]	infos	= new MBeanOperationInfo[ existing.length + 1 ];
		System.arraycopy( existing, 0, infos, 0, existing.length );
		infos[ infos.length -1 ]	= refreshInfo;
		
		return( infos );
	}
	
		protected MBeanInfo
	buildMBeanInfo()
	{
		final MBeanInfo	superMBeanInfo	= super.getMBeanInfo();
		
		final MBeanAttributeInfo[]		attributeInfos		=
				buildAttributeInfos( superMBeanInfo.getAttributes() );
		final MBeanOperationInfo[]		operationInfos		=
				buildOperationInfos( superMBeanInfo.getOperations() );
		
		final MBeanInfo	info	= new MBeanInfo( this.getClass().getName(),
									"exposes dotted-names as Attributes",
									attributeInfos,
									superMBeanInfo.getConstructors(),
									operationInfos,
									superMBeanInfo.getNotifications() );
		
		return( info );
	}
	
	
	
	
		private static Attribute
	namePairToAttribute( String pair )
	{
		final int			delimIndex	= pair.indexOf( "=" );
		assert( delimIndex >= 1 );
		final String		name	= pair.substring( 0, delimIndex );
		final String		value	= pair.substring( delimIndex + 1, pair.length() );
		
		return( new Attribute( name, value ) );
	}
	
		private static String
	attributeToNamePair( Attribute attr )
	{
		return( attr.getName() + "=" + attr.getValue() );
	}
	
		protected final boolean
	isLegalAttributeName( final String name )
	{
		ensureAttributes();
		return( getAttributes().keySet().contains( name ) ||
				mParentAttributeNames.contains( name ) );
	}
	
		protected final void
	ensureAttributes()
	{
		if ( mAttributes == null )
		{
			refreshAttributes();
		}
	}

		protected final Map<String,Attribute>
	getAttributes()
	{
		ensureAttributes();
		
		return( mAttributes );
	}

		protected final String[]
	getDottedNamesArray()
	{
		final Map<String,Attribute>	map	= getAttributes();
		
		final Set<String>	keySet	= map.keySet();
		
		return( (String[])keySet.toArray( new String[ keySet.size() ] ) );
	}
	
	
		private final void
	checkLegalName( String name )
		throws AttributeNotFoundException
	{
		if ( ! isLegalAttributeName( name ) )
		{	    
			throw new AttributeNotFoundException( "illegal attribute name: " + name );
		}
	}
	

	/**
		Refresh the MBeanInfo to reflect the currently available attributes.
	 */
	private static final String	ALL	= "*";
		final void
	refreshAttributes()
	{
		Object	result	= null;
		
		//trace( "##### DottedNamesBase.refreshAttributeNames" );
		result	= dottedNameGet( ALL );
		
		// results is an array of length 1.  It should contain an Object[] containining
		// everything obtained from "ALL"
		final Attribute[]	values	= (Attribute[])result;
		
		// extract the name of each attribute
		final Map<String,Attribute>	map	= new HashMap<String,Attribute>();
		for( final Attribute attr : values )
		{
			map.put( attr.getName(), attr );
		}
		
		mAttributes	= map;
	}
	
		public final void
	refresh()
	{
		trace( "##### DottedNamesBase.refresh" );
		refreshAttributes();
		mMBeanInfo	= buildMBeanInfo();
	}
}








