/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */
 
/*
 */

package com.sun.enterprise.management.support;

import java.util.Set;
import java.util.Collections;

import com.sun.appserv.management.util.misc.ObjectUtil;


/**
	Basic data from which we derive all our TypeInfo. Any j2eeType must either
	have 1 or more legal parent types ( in which case it is a subType),
	or must have a contained-by j2eeType (possibly null), in which case it is a
	top-level type, possibly contained by something else.
	<p>
	Separating these two ideas enables reasonably short types that don't have to
	artifically include the singletons they are logically contained in.  For example,
	it enables the type "X-ConfigConfig" instead of 
	"X-DomainRoot.X-DomainConfig.X-ConfigConfig", which is considerably longer
	than (unnecessarily so).
 */
class TypeData
{
	private final String	    mJ2EEType;
	private final Set<String>	mLegalParentsTypes;
	private final String	    mContainedByJ2EEType;
	
 	
 	    public int
 	hashCode()
 	{
 	    return ObjectUtil.hashCode(
 	            mJ2EEType, mLegalParentsTypes, mContainedByJ2EEType);
 	}
 	
 	    public boolean
 	equals( final Object rhs )
 	{
 	    boolean equals  = false;
 	    
 	    if ( this == rhs )
 	    {
 	        equals  = true;
 	    }
 	    else if ( ! (rhs instanceof TypeData) )
 	    {
 	        equals  = false;
 	    }
 	    else
 	    {
 	        final TypeData rhsTypeData  = (TypeData)rhs;
 	        
 	        equals  =  ObjectUtil.equals( mJ2EEType, rhsTypeData.mJ2EEType ) &&
 	                    mLegalParentsTypes.equals( rhsTypeData.mLegalParentsTypes ) &&
 	                    ObjectUtil.equals( mContainedByJ2EEType, rhsTypeData.mContainedByJ2EEType );
 	    }
 	    
 	    return equals;
 	}
 	
	/**
		Same as TypeData( j2eeType, newSet( parentJ2EEType ) )
	 */
	protected TypeData(
		final String	j2eeType,
		final String	parentJ2EEType )
	{
		this( j2eeType, Collections.singleton( parentJ2EEType ) );
	}
	
	/**
		@param j2eeType	the j2eeType
		@param legalParentJ2EETypes	the possible j2eeTypes of the parent (0 or more)
	 */
	protected TypeData(
		final String	j2eeType,
		final Set<String>		legalParentJ2EETypes )
	{
		this( j2eeType, legalParentJ2EETypes, null );
	}
	
	/**
		@param j2eeType	the j2eeType
		@param legalParentJ2EETypes	the possible j2eeTypes of the parent (0 or more)
		@param containingJ2EEType if non-null, the containing type, legalParentJ2EETypes must be null
	 */
	protected TypeData(
		final String	j2eeType,
		final Set<String>		legalParentJ2EETypes,
		final String	containedByJ2EEType )
	{
		if ( containedByJ2EEType != null && legalParentJ2EETypes != null )
		{
			throw new IllegalArgumentException( "can't have both parents and contained type" );
		}
		
		mJ2EEType				= j2eeType;
		if ( containedByJ2EEType != null )
		{
			mContainedByJ2EEType	= containedByJ2EEType;
			mLegalParentsTypes		= null;
		}
		else
		{
			mContainedByJ2EEType	= null;
			mLegalParentsTypes		= legalParentJ2EETypes == null ?
					null : Collections.unmodifiableSet( legalParentJ2EETypes );
		}
	}
	
		public final Set<String>
	getLegalParentJ2EETypes()
	{
		return( mLegalParentsTypes );
	}
	
		public final String
	getJ2EEType()
	{
		return( mJ2EEType );
	}
	
		public boolean
	isSubType()
	{
		return( mLegalParentsTypes != null ); 
	}
	
		public final String
	getContaineeByJ2EEType()
	{
		return( mContainedByJ2EEType );
	}
}

