/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin/mbeanapi-impl/tests/com/sun/enterprise/management/base/NotificationEmitterServiceTest.java,v 1.4 2006/03/09 20:30:51 llc Exp $
 * $Revision: 1.4 $
 * $Date: 2006/03/09 20:30:51 $
 */
package com.sun.enterprise.management.base;

import javax.management.Notification;
import javax.management.NotificationListener;

import com.sun.appserv.management.base.NotificationEmitterService;
import com.sun.appserv.management.base.NotificationEmitterServiceKeys;
import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.util.jmx.NotificationBuilder;


import com.sun.enterprise.management.AMXTestBase;
import com.sun.enterprise.management.Capabilities;


/**
 */
public final class NotificationEmitterServiceTest extends AMXTestBase
{
		public
	NotificationEmitterServiceTest( )
	{
	}
	    public static Capabilities
	getCapabilities()
	{
	    return getOfflineCapableCapabilities( true );
	}

		public NotificationEmitterService
	getNotificationEmitterService()
	{
		return getDomainRoot().getDomainNotificationEmitterService();
	}
	
		public void
	testGet()
	{
		assert getNotificationEmitterService() != null;
	}
	
	
	private final static class testEmitListener implements NotificationListener
	{
		static final String	TEST_TYPE	= "unittests.testEmitListener";
		private Notification	mNotification;
		private int				mNumHeard;
		
		public	testEmitListener()
		{
			mNumHeard		= 0;
			mNotification	= null;
		}
		
			public void
		handleNotification( final Notification notif, final Object handback )
		{
			mNotification	= notif;
			++mNumHeard;
		}
		
		public Notification	getLast()	{ return mNotification; }
		public int		getNumHeard()	{ return mNumHeard; }
		public void	clear()	{ mNumHeard = 0; mNotification	= null; }
	}

	private static final String TEST_SOURCE	= "NotificationEmitterServiceTest";
	private static final String TEST_MESSAGE	= "Message";
	private static final String TEST_KEY	= "TestKey";
	private static final String TEST_VALUE	= "test value";
	
		public void
	testEmit()
	{
		final NotificationEmitterService	nes	= getNotificationEmitterService();
		
		final NotificationBuilder	builder	=
			new NotificationBuilder( testEmitListener.TEST_TYPE, TEST_SOURCE );
		
		final testEmitListener	listener	= new testEmitListener();
		nes.addNotificationListener( listener, null, null);
		final Notification	notif	= builder.buildNew( TEST_MESSAGE);
		builder.putMapData( notif, TEST_KEY, TEST_VALUE );
		
		// call emitNotification() and verify it was emitted
		nes.emitNotification( notif );
		while( listener.getLast() == null )
		{
			// wait...
			mySleep( 20 );
		}
		final Notification	retrieved	= listener.getLast();
		assert( retrieved.getType().equals( notif.getType() ) );
		assert( Util.getAMXNotificationValue( retrieved, TEST_KEY, String.class).equals( TEST_VALUE ) );
		assert( retrieved.getSource().equals( TEST_SOURCE ) );
		assert( retrieved.getMessage().equals( TEST_MESSAGE ) );
		
		// now emit many Notifications.
		listener.clear();
		long	start	= now();
		final int	ITER	= 200;
		for( int i = 0; i < ITER; ++i)
		{
			final Notification	temp	= builder.buildNew( TEST_MESSAGE);
		    builder.putMapData( notif, TEST_KEY, TEST_VALUE );
			nes.emitNotification( temp );
		}
		printElapsedIter( "Emitted Notifications", start, ITER );
		start	= now();
		while( listener.getNumHeard() < ITER )
		{
			mySleep( 10 );
		}
		printElapsedIter( "After sending, received emitted Notifications", start, ITER );
	}
}










