/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin/mbeanapi-impl/tests/com/sun/enterprise/management/client/ProxyFactoryTest.java,v 1.4 2006/03/09 20:30:52 llc Exp $
 * $Revision: 1.4 $
 * $Date: 2006/03/09 20:30:52 $
 */
package com.sun.enterprise.management.client;

import java.util.Set;
import java.util.Map;
import java.util.List;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Level;

import javax.management.ObjectName;
import javax.management.MBeanServerConnection;
import javax.management.AttributeList;
import javax.management.MBeanInfo;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanOperationInfo;
import javax.management.InstanceNotFoundException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.AttributeChangeNotification;

import com.sun.appserv.management.base.AMX;
import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.base.NotificationServiceMgr;
import com.sun.appserv.management.base.NotificationService;
import com.sun.appserv.management.helper.NotificationServiceHelper;
import com.sun.appserv.management.base.QueryMgr;
import com.sun.appserv.management.client.ProxyFactory;
import com.sun.appserv.management.util.misc.ExceptionUtil;


import com.sun.enterprise.management.AMXTestBase;
import com.sun.enterprise.management.Capabilities;


/**
 */
public final class ProxyFactoryTest extends AMXTestBase
{
		public
	ProxyFactoryTest( )
	{
	}
	    public static Capabilities
	getCapabilities()
	{
	    return getOfflineCapableCapabilities( false );
	}
	

	/**
		Verify that when an MBean is removed, the ProxyFactory
		detects this, and removes any proxy from its cache.
	 */
		public void
	testProxyFactoryDetectsMBeanRemoved()
		throws InstanceNotFoundException
	{
		// use the NotificationServiceMgr as a convenient way of making
		// an MBean (a NotificationService) come and go.
		final NotificationServiceMgr	mgr	= getDomainRoot().getNotificationServiceMgr();
		final NotificationService	ns	= mgr.createNotificationService( "UserData", 10 );
		final ObjectName	nsObjectName	= Util.getObjectName( ns );
		assert( ns.getUserData().equals( "UserData" ) );
		
		final ProxyFactory	factory	= getProxyFactory();
		final NotificationService	proxy	=
			factory.getProxy( nsObjectName, NotificationService.class, false );
		assert( proxy == ns ) : "proxies differ: " + ns + "\n" + proxy;
		
		mgr.removeNotificationService( ns.getName() );

		int	iterations	= 0;
		long	sleepMillis	= 10;
		while( factory.getProxy( nsObjectName, NotificationService.class, false ) != null )
		{
			mySleep( sleepMillis );
			if ( sleepMillis >= 400 )
			{
				trace( "testProxyFactoryDetectsMBeanRemoved: waiting for proxy to be removed" );
			}
			sleepMillis	*= 2;
		}
	}
}









