/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.management.config;

import java.util.Set;

import com.sun.appserv.management.base.AMX;
import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.util.misc.ExceptionUtil;

import com.sun.appserv.management.config.DomainConfig;
import com.sun.appserv.management.config.ConfigConfig;
import com.sun.appserv.management.config.SecurityServiceConfig;
import com.sun.appserv.management.config.AdminServiceConfig;

import com.sun.enterprise.management.AMXTestBase;
import com.sun.enterprise.management.config.*;
import com.sun.enterprise.management.support.AMXDebugStuff;


/**
    This test should normally be run before the generic tests
    so that it can set up default items for many of the config elements
    so that the generic tests will actually test them. Otherwise,
    when the generic tests are run, they won't see any instances
    of many of the AMXConfig MBeans.
    <p>
    If there are errors doing this, disable this test in amxtest.classes,
    fix the error in the specific place it's occurring, then re-enabled
    this test.
 */
public final class ConfigRunMeFirstTest extends AMXTestBase
{
		public
	ConfigRunMeFirstTest( )
	{
	}
	
	    private void
	setupConfig()
	{
	    final DomainConfig  dc  = getDomainConfig();
	    final ConfigConfig  cc  = getConfigConfig();
	    final SecurityServiceConfig  ss  = cc.getSecurityServiceConfig();
	    final AdminServiceConfig  as  = cc.getAdminServiceConfig();
	    
	    AuditModuleConfigTest.ensureDefaultInstance( ss );
	    
	    AuthRealmConfigTest.ensureDefaultInstance( ss );
	    
	    ConnectorConnectionPoolConfigTest.ensureDefaultInstance( dc );
	    
	    JMXConnectorConfigTest.ensureDefaultInstance( as );
	    
	    ResourceAdapterConfigTest.ensureDefaultInstance( dc );
	    
        AdminObjectResourceConfigTest.ensureDefaultInstance( dc );
        
        JDBCConnectionPoolConfigTest.ensureDefaultInstance( dc );
        
        JDBCResourceConfigTest.ensureDefaultInstance( dc );
        
        JNDIResourceConfigTest.ensureDefaultInstance( dc );
        
        ConnectorResourceConfigTest.ensureDefaultInstance( dc );
        
        CustomMBeanConfigTest.ensureDefaultInstance( dc );
        
        JACCProviderConfigTest.ensureDefaultInstance( ss );
        
        MailResourceConfigTest.ensureDefaultInstance( dc );
        
        ThreadPoolConfigTest.ensureDefaultInstance( cc );
        
        PersistenceManagerFactoryResourceConfigTest.ensureDefaultInstance( dc );
        
        CustomResourceConfigTest.ensureDefaultInstance( dc );
        
        ProfilerConfigTest.ensureDefaultInstance( cc.getJavaConfig() );
        
        LifecycleModuleConfigTest.ensureDefaultInstance( dc );
	}
	
	    public void
	testSetup()
	{
	    if ( checkNotOffline( "testIllegalCreate" ) )
	    {
	        setupConfig();
	    }
	}
}














