/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.management.config;

import java.util.Map;
import java.util.HashMap;

import com.sun.appserv.management.base.Container;
import com.sun.appserv.management.base.XTypes;

import com.sun.appserv.management.config.AMXConfig;
import com.sun.appserv.management.config.DomainConfig;
import com.sun.appserv.management.config.ConnectorConnectionPoolConfig;
import com.sun.appserv.management.config.ConnectorConnectionPoolConfigKeys;

import com.sun.appserv.management.util.misc.MapUtil;

/**
 */
public final class ConnectorConnectionPoolConfigTest extends ConfigMgrTestBase
{
    private static final String CONNECTOR_DEF_NAME = "javax.resource.cci.ConnectionFactory";
    private static final String RESOURCE_ADAPTOR_NAME = "cciblackbox-tx";
	private static final Map<String,String>	OPTIONS	= MapUtil.newMap(
		ConnectorConnectionPoolConfigKeys.IGNORE_MISSING_REFERENCES_KEY, "true" );

    public ConnectorConnectionPoolConfigTest()
    {
	    if ( checkNotOffline( "ensureDefaultInstance" ) )
	    {
	        ensureDefaultInstance( getDomainConfig() );
	    }
    }
    
        public static String
    getDefaultInstanceName()
    {
        return getDefaultInstanceName( "ConnectorConnectionPoolConfig" );
    }
    
	    public static ConnectorConnectionPoolConfig
	ensureDefaultInstance( final DomainConfig dc )
	{
	    ConnectorConnectionPoolConfig result =
	        dc.getConnectorConnectionPoolConfigMap().get( getDefaultInstanceName() );
	    
	    if ( result == null )
	    {
	        result  = createInstance( dc, getDefaultInstanceName(),
	            ResourceAdapterConfigTest.ensureDefaultInstance( dc ).getName(),
	            CONNECTOR_DEF_NAME, OPTIONS);
	    }
	    
	    return result;
	}
	
	    public static ConnectorConnectionPoolConfig
	createInstance(
	    final DomainConfig dc,
	    final String    name,
	    final String    resourceAdapterName,
	    final String    connectorDefinitionName,
	    Map<String,String> optional)
	{
	    return dc.createConnectorConnectionPoolConfig( name,
	            connectorDefinitionName, resourceAdapterName, optional );
	}
	
    	protected Container
	getProgenyContainer()
	{
		return getDomainConfig();
	}

		protected String
	getProgenyJ2EEType()
	{
		return XTypes.CONNECTOR_CONNECTION_POOL_CONFIG;
	}

		protected void
	removeProgeny( final String name )
	{
		getDomainConfig().removeConnectorConnectionPoolConfig( name );
	}
	
		protected final AMXConfig
	createProgeny(final String name, final Map<String,String> options ) 
	{
		final Map<String,String>	allOptions	= MapUtil.newMap( OPTIONS, options );
		
	    final ConnectorConnectionPoolConfig	config	=
	    	getDomainConfig().createConnectorConnectionPoolConfig(
		               name,
		               RESOURCE_ADAPTOR_NAME,
		               CONNECTOR_DEF_NAME, allOptions);
		return( config );
	}
}


