/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.management.config;

import java.util.Set;
import java.util.Map;
import java.util.Iterator;

import javax.management.ObjectName;

import com.sun.appserv.management.config.NamedConfigElement;
import com.sun.appserv.management.config.DomainConfig;

import com.sun.enterprise.management.AMXTestBase;
import com.sun.enterprise.management.Capabilities;
import com.sun.appserv.management.base.AMX;
import com.sun.appserv.management.config.*;


import com.sun.appserv.management.util.misc.StringUtil;
import com.sun.appserv.management.base.Util;


/**
 */
public final class ManagementRulesConfigTest extends AMXTestBase
{
    //private static final String ACTION_MBEAN_NAME =
        //"user:type=rule-action,name=" + CustomMBeanConfigTest.getDefaultInstanceName();
    private static final String ACTION_MBEAN_NAME   = "com.foo.Bar";
    
		public
	ManagementRulesConfigTest()
	{
	    if ( checkNotOffline( "ensureDefaultInstance" ) )
	    {
	        ensureDefaultInstance( getConfigConfig() );
	    }
	}
	
	    public static String
    getDefaultInstanceName()
    {
        return getDefaultInstanceName( "ManagementRulesConfigTest" );
    }
    
        public static ManagementRuleConfig
	ensureDefaultInstance( final ConfigConfig config )
	{
	    final ManagementRulesConfig rules   = getManagementRulesConfig(config);
	    
	    ManagementRuleConfig   result  =
	        rules.getManagementRuleConfigMap().get( getDefaultInstanceName() );
	    
	    if ( result == null )
	    {
	        result  = createRule( rules, getDefaultInstanceName(), EventTypeValues.TRACE, ACTION_MBEAN_NAME );
	    }
	    
	    return result;
	}
	
	    private static ManagementRulesConfig
	getManagementRulesConfig( final ConfigConfig config )
	{
	    return config.getManagementRulesConfig();
	}
	
	
	    private ManagementRulesConfig
	getManagementRulesConfig( )
	{
	    return getManagementRulesConfig( getConfigConfig() );
	}
	
		public void
	testGet()
	{
	    final ManagementRulesConfig rulesConfig = getManagementRulesConfig();
	    
	    if ( rulesConfig != null )
	    {
    	    final Map<String,ManagementRuleConfig>  ruleConfigs =
    	        rulesConfig.getManagementRuleConfigMap();
	        assert( ruleConfigs != null );
	    }
	    else
	    {
	        warning( "testGet: ManagementRulesConfig is null...skipping test" );
	    }
	}
	
	
	    private String
    createName( final int i )
    {
        return "rule" + i;
    }
    
	    private static ManagementRuleConfig
    createRule(
        final ManagementRulesConfig  rules,
        final String    name,
        final String    eventType,
        final String    actionMBeanName )
    {
	    final ManagementRuleConfig rule =
	        rules.createManagementRuleConfig(
	            name, eventType, actionMBeanName, null );
	    
	    return rule;
    }
    
        private void
    removeRule( final String name )
    {
	    getManagementRulesConfig().removeManagementRuleConfig( name );
    }
        private void
    testEventConfig( final EventConfig eventConfig )
    {
        assert( eventConfig != null );
        
        final String eventType  = eventConfig.getType();
        eventConfig.setType( eventType );
        eventConfig.setDescription( "test description" );
    }
    
        private void
    testRuleConfig( final ManagementRuleConfig ruleConfig )
    {
        final EventConfig   eventConfig = ruleConfig.getEventConfig();
        assert( eventConfig != null );
        testEventConfig( eventConfig );
        
        final ActionConfig  actionConfig = ruleConfig.getActionConfig();
        if ( actionConfig != null )
        {
            final String mbeanName  = actionConfig.getActionMBeanName();
            actionConfig.setActionMBeanName( mbeanName );
        }
    }
	
	
		public ManagementRuleConfig
	createAndTestRule( final int id )
	    throws Exception
	{
	    final ManagementRulesConfig rules   = getManagementRulesConfig();
	    
        final String    name    = createName( id );
        
        if ( rules.getManagementRuleConfigMap().get( name ) != null )
        {
            removeRule( name );
            warning( "Removed left over ManagementRuleConfig: " + StringUtil.quote( name ) );
        }
        
        String actionMBeanName = ((id%2) ==0) ? ACTION_MBEAN_NAME : null;
        
        ManagementRuleConfig    ruleConfig =
            createRule( rules, name, EventTypeValues.TRACE, actionMBeanName );
        
        testRuleConfig( ruleConfig );
        ActionConfig actionConfig   = ruleConfig.getActionConfig();
        if ( actionConfig  == null )
        {
            actionConfig = ruleConfig.createActionConfig( ACTION_MBEAN_NAME );
            testRuleConfig( ruleConfig );
        }
        
        try
        {
            ruleConfig.createActionConfig( ACTION_MBEAN_NAME );
        }
        catch( Exception e )
        {
            // good, we expect to be here
        }
        
        try
        {
            ruleConfig.createActionConfig( null );
        }
        catch( Exception e )
        {
            // good, we expect to be here
        }
        
        return ruleConfig;
	}
	
		public void
	testCreateRule()
	    throws Exception
	{
	    final ManagementRulesConfig rulesConfig = getManagementRulesConfig();
	    if ( rulesConfig == null )
	    {
	        warning( "testCreateRule: ManagementRulesConfig is null...skipping test" );
	        return;
	    }
	    
	    final int   NUM = 6;
	    final ManagementRuleConfig[] ruleConfigs = new ManagementRuleConfig[ NUM ];
	    
	    try
	    {
    	    for( int i = 0; i < NUM; ++i )
    	    {
    	        ruleConfigs[ i ]    = createAndTestRule( i );
    	    }
	    }
	    finally
	    {
    	    for( int i = 0; i < NUM; ++i )
    	    {
    	        if ( ruleConfigs[ i ] != null )
    	        {
    	            removeRule( ruleConfigs[ i ].getName() );
    	        }
    	    }
	    }
	}
	
	
}



























