/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.management.config;

import java.util.Map;
import java.util.HashMap;

import javax.management.ObjectName;

import com.sun.appserv.management.DomainRoot;
import com.sun.appserv.management.config.DomainConfig;
import com.sun.appserv.management.config.SecurityMapConfig;
import com.sun.appserv.management.config.SecurityServiceConfig;
import com.sun.appserv.management.config.MessageSecurityConfig;
import com.sun.appserv.management.config.ProviderConfig;
import com.sun.appserv.management.config.ConfigConfig;

import com.sun.enterprise.management.AMXTestBase;
import com.sun.enterprise.management.Capabilities;

import com.sun.appserv.management.util.misc.CollectionUtil;


/**
 */
public final class MessageSecurityConfigTest extends AMXTestBase
{
		public
	MessageSecurityConfigTest()
	{
	}
    
        private static SecurityServiceConfig
    getDefaultSecurityServiceConfig( final DomainRoot domainRoot )
    {
        final ConfigConfig  config  = ConfigConfigTest.ensureDefaultInstance( domainRoot );
        final SecurityServiceConfig ss  = config.getSecurityServiceConfig();
        assert( ss != null );
        return ss;
    }
        
        private static MessageSecurityConfig
    create(
        final DomainRoot domainRoot,
        final String     authLayer )
    {
        final SecurityServiceConfig ss = getDefaultSecurityServiceConfig( domainRoot );
        
        final Map<String,String>    optional   = new HashMap<String,String>();
        final MessageSecurityConfig msc = ss.createMessageSecurityConfig( authLayer,
                "ClientProvider", ProviderConfig.PROVIDER_TYPE_CLIENT, 
                "com.sun.xml.wss.provider.ClientSecurityAuthModul", optional );
        
        msc.createProviderConfig( "ServerProvider",
           ProviderConfig.PROVIDER_TYPE_SERVER, "com.sun.xml.wss.provider.ServerSecurityAuthModule", optional );
           
        msc.createProviderConfig( "DummyProvider1",
           ProviderConfig.PROVIDER_TYPE_SERVER, "AMX.TEST.DummySecurityAuthModule", optional );
           
        msc.createProviderConfig( "DummyProvider2",
           ProviderConfig.PROVIDER_TYPE_SERVER, "AMX.TEST.DummySecurityAuthModule", optional );
        
        msc.removeProviderConfig( "DummyProvider1" );
        msc.removeProviderConfig( "DummyProvider2" );
        
        return msc;
    }
    
    static private final String AUTH_TYPE  = MessageSecurityConfig.AUTH_LAYER_HTTP_SERVLET;
    
    /**
        Note: this can't be tested except by making a new one, and the names are predefined, so
        if it already exists, it must be deleted first.
     */
        public void
	testCreateRemove( )
	{
        final SecurityServiceConfig ss  = getDefaultSecurityServiceConfig( getDomainRoot() );
        final Map<String,MessageSecurityConfig> messageSecurityConfigs = ss.getMessageSecurityConfigMap();
        MessageSecurityConfig   msc = messageSecurityConfigs.get( AUTH_TYPE );
        
        if ( msc != null )
        {
            ss.removeMessageSecurityConfig( AUTH_TYPE );
            msc = null;
        }
        
        msc = create( getDomainRoot(), AUTH_TYPE );
        
        ss.removeMessageSecurityConfig( AUTH_TYPE );
    }
    	
}



























