/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.management.ext.logging;

import java.util.Map;
import java.util.Date;
import java.util.logging.Level;

import javax.management.openmbean.CompositeData;
import javax.management.openmbean.OpenDataException;

import com.sun.appserv.management.ext.logging.LogQueryEntry;
import com.sun.appserv.management.ext.logging.LogQueryEntryImpl;


import com.sun.enterprise.management.Capabilities;

/**
 */
public final class LogQueryEntryImplTest extends junit.framework.TestCase
{
		public
	LogQueryEntryImplTest( )
	{
	}
	
	
	private static final String N1  = "foo";
	private static final String V1  = "foo-value";
	private static final String N2  = LogQueryEntry.THREAD_ID_KEY;
	private static final String V2  = "13347";
	
	    private static String
	nvp( final String name, final String value )
	{
	    return( name + "=" + value );
	}
	
	    public static LogQueryEntryImpl
	createDummy()
	{
	    return new LogQueryEntryImpl(
	        0,
	        new Date(),
	        Level.OFF.toString(),
	        "Sun Appserver whatever",
	        "hello world",
	        "MSG01",
            "module",
            nvp(N1,V1) + ";" + nvp(N2,V2) );
	}
	
	    public void
	testCreate()
	{
	    createDummy();
	}
	
	    public void
	testEquals()
	{
	    final LogQueryEntryImpl d = createDummy();
	    
	    assertEquals( d, d );
	    
	    final LogQueryEntryImpl dCopy = new LogQueryEntryImpl(
    	    d.getRecordNumber(),
    	    d.getDate(),
    	    d.getLevel(),
    	    d.getProductName(),
    	    d.getMessage(),
    	    d.getMessageID(),
    	    d.getModule(),
    	    d.getNameValuePairs() );
    	
    	assertEquals( d, dCopy );
    	assertEquals( dCopy, d );
	}
	
	
	    public void
	testGetNameValuePairsMap()
	{
	    final LogQueryEntryImpl d = createDummy();
	    
	    final Map<String,String>    m   = d.getNameValuePairsMap();
	    assertEquals( V1, m.get( N1 ) );
	    assertEquals( V2, m.get( N2 ) );
	}
	
	    public void
	testGetters()
	    throws OpenDataException
	{
	    final LogQueryEntryImpl d = createDummy();
	    
	    d.getRecordNumber();
	    d.getDate();
	    d.getLevel();
	    d.getMessage();
	    d.getMessageID();
	    d.getModule();
	    d.getMessage();
	    d.getNameValuePairs();
	    d.getNameValuePairsMap();
	}
	
	/*
	    public void
	testAsMap()
	{
	    final LogQueryEntryImpl dummy = createDummy();
	    
	    final Mapxxx   m   = dummy.asMap();
	    
	    final LogQueryEntryImpl copy    = new LogQueryEntryImpl( m );
	    assertEquals( dummy, copy );
	}
	
	    public void
	testAsCompositeData()
	    throws OpenDataException
	{
	    final LogQueryEntryImpl dummy = createDummy();
	    
	    final CompositeData   d   = dummy.asCompositeData();
	    
	    final LogQueryEntryImpl copy    = new LogQueryEntryImpl( d );
	    assertEquals( dummy, copy );
	    
	    assert( copy.toString().equals( dummy.toString() ) );
	}
	*/
}









