/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin/mbeans/src/java/com/sun/enterprise/admin/dottedname/DottedNameResolverFromRegistry.java,v 1.3 2005/12/25 03:42:04 tcfujii Exp $
 * $Revision: 1.3 $
 * $Date: 2005/12/25 03:42:04 $
 */


package com.sun.enterprise.admin.dottedname;

import javax.management.ObjectName;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;



/*
	This implementation resolves a dotted name to an ObjectName by looking it up
	in a registry (presumably the single well-known one).
	
	Aliased dotted names will not work; only "real" dotted names will work.
	
	Though this implementation offers little value over querying the registry itself,
	other implementations may add additional processing over and above just
	querying the registry.
 */
public class DottedNameResolverFromRegistry implements DottedNameResolver
{
	final DottedNameRegistry		mRegistry;
	
		public
	DottedNameResolverFromRegistry( DottedNameRegistry registry )
		throws MalformedObjectNameException
	{
		mRegistry	= registry;
	}
	
		public ObjectName
	resolveDottedName( String dottedName )
	{
		return( mRegistry.dottedNameToObjectName( dottedName ) );
	}
}



