/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * $Id: IDomainMBean.java,v 1.3 2005/12/25 03:42:10 tcfujii Exp $
 */

package com.sun.enterprise.admin.mbeanapi;

import javax.management.MBeanException;
import javax.management.AttributeList;
import com.sun.enterprise.admin.config.MBeanConfigException;

public interface IDomainMBean 
{
    public AttributeList getDefaultCustomProperties(String mbeanTypeName, AttributeList attributeList)
        throws MBeanException;
    
    public AttributeList getDefaultAttributeValues(String mbeanTypeName, String attrNames[])
        throws MBeanException;
     
    public String getConfigDir()
        throws MBeanException; 
    
    /**
     * Returns the name of this domain.
     *
     * @return   domain name
     */
    public String getName() throws MBeanConfigException, MBeanException; 
}
