/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * ExceptionHandler.java
 *
 * Created on February 26, 2004, 3:39 PM
 */

package com.sun.enterprise.admin.mbeans;

import com.sun.enterprise.admin.servermgmt.InstanceException;
import com.sun.enterprise.config.ConfigException;

import com.sun.enterprise.util.i18n.StringManagerBase;

import java.util.logging.Logger;
import java.util.logging.Level;

/**
 *
 * @author  kebbs
 */
public class ExceptionHandler {
    
    private Logger _logger;
    
    
    /**
     * Create a new exception handler with the specified logger
     * @param logger
     */    
    public ExceptionHandler(Logger logger) {
        _logger = logger;
    }
     
    protected Logger getLogger() 
    {
        return _logger;
    }  
                           
    public InstanceException handleInstanceException(Exception ex, String messageId, String arg) 
    {
        return handleInstanceException(ex, messageId, new String[] {arg});
    }
               
    /**
     * Convert an incoming exception to an InstanceException and log if the incoming exception
     * is not an InstanceException.
     * @param ex The exception
     * @param messageId the resource bundle id of the message to log
     * @param args arguments to be passed to the log message
     * @return InstanceException
     */    
    public InstanceException handleInstanceException(Exception ex, String messageId, String[] args) 
    {
        InstanceException result = null;
        Level level = Level.FINE;
        if (ex instanceof InstanceException) {                       
            result = (InstanceException)ex;            
        } else if (ex instanceof ConfigException) {            
            result = new InstanceException(ex);
        } else {  
            level = Level.WARNING;
            result = new InstanceException(ex);
        }
        StringManagerBase sm = StringManagerBase.getStringManager(getLogger().getResourceBundleName());            
        getLogger().log(level, sm.getString(messageId, args), ex);             
        return result;
    }                    
            
    public ConfigException handleConfigException(Exception ex, String messageId, String arg) 
    {
        return handleConfigException(ex, messageId, new String[] {arg});
    }
    
    /**
     * Convert an incoming exception to an ConfigException and log if the incoming exception
     * is not a ConfigException
     * @param ex The exception
     * @param messageId the resource bundle id of the message to log
     * @param args arguments to be passed to the log message
     * @return ConfgException
     */    
    public ConfigException handleConfigException(Exception ex, String messageId, String[] args)
    {
        ConfigException result = null;
        Level level = Level.FINE;
        if (ex instanceof ConfigException) {                       
            result = (ConfigException)ex;
        } else {  
            level = Level.WARNING;
            result = new ConfigException(ex);
        }
        StringManagerBase sm = StringManagerBase.getStringManager(getLogger().getResourceBundleName());            
        getLogger().log(level, sm.getString(messageId, args), ex);             
        return result;
    }    
}
