/*
 * AsyncHandlerFactory.java
 *
 * Created on June 16, 2006, 2:00 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package com.sun.enterprise.admin.monitor.callflow;
import java.util.logging.Level;
import java.util.logging.Logger;
import com.sun.enterprise.admin.common.constant.AdminConstants;

/**
 * @todo Add logging code
 * @author hsingh
 */
public class AsyncHandlerFactory {
    
    private static AsyncHandlerIntf singletonAsyncHandler = null;
    private static final Logger logger =
            Logger.getLogger(AdminConstants.kLoggerName);
    
    private static boolean traceOn = false;
    /** Creates a new instance of AsyncHandlerFactory */
    private AsyncHandlerFactory() {
        traceOn = TraceOnHelper.isTraceOn();
    }
    
    public static synchronized AsyncHandlerIntf getInstance (){
        if (singletonAsyncHandler == null){
            boolean perfImpl =
                    System.getProperty("com.sun.enterprise.callflow.perf", "true").equals("true");
            if (perfImpl){
                if (traceOn){
                    logger.log (Level.INFO, "Callflow: Starting Performant " +
                            "Implementation!. To switch to old implementation" +
                            " Add system property com.sun.enterprise.admin." +
                            "callflow.perf=false");
                }
                singletonAsyncHandler = AsyncHandlerProducer.getInstance();
            } else{
                if (traceOn){
                    logger.log (Level.INFO, "Callflow: Starting Old - Non " +
                            "Performant Implementation!");
                }
                singletonAsyncHandler = new AsyncHandler ();
            }
        }
        return singletonAsyncHandler;
    }    
    
}
