/*
 * DbHandler.java
 *
 * Created on September 21, 2006, 11:25 AM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package com.sun.enterprise.admin.monitor.callflow;
import java.util.logging.Level;
import java.util.logging.Logger;
import com.sun.enterprise.admin.common.constant.AdminConstants;

/**
 *
 * @author Harpreet Singh
 */
public class DbHandler implements Handler{
    String name = "DbHandler";
    private DbAccessObject db;
    private static final Logger logger =
            Logger.getLogger(AdminConstants.kLoggerName);

    // special callflow debug flag
    boolean traceOn = false;
    
    /**
     * Creates a new instance of DbHandler
     */
    public DbHandler(DbAccessObject db) {
        this.db = db;
        boolean traceOn = TraceOnHelper.isTraceOn();
    }
    
    public void handle (TransferObject[] to){
        if (traceOn){
            for (int i=0; i<to.length; i++){
                logger.log(Level.INFO, "DBHandler.handle :"+
                        to[i].getClass().getName());
                break;
            }
        }
        db.insert(to);
    }
  
    public String getName (){
        return name;
    }
    public void setName (String name){
        this.name = name;
    }
}
