/*
 * HandlerChain.java
 *
 * Created on September 21, 2006, 11:28 AM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package com.sun.enterprise.admin.monitor.callflow;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import com.sun.enterprise.admin.common.constant.AdminConstants;

/**
 *
 * @author hsingh
 */
public class HandlerChain {
    private static final Logger logger =
            Logger.getLogger(AdminConstants.kLoggerName);
    
    private boolean traceOn = false;
    Map<String, Handler> handlers = new HashMap<String, Handler> ();
    /** Creates a new instance of HandlerChain */
    public HandlerChain() {
        traceOn = TraceOnHelper.isTraceOn();
    }
    public void addHandler (Handler handler){
        String name = handler.getName();
        if (name == null){
            name = handler.getClass().getName();
        }
        handlers.put(name, handler);
        if (traceOn){
            StringBuffer sb = new StringBuffer ();
            for (String handlerName : handlers.keySet()){
                sb.append(handlerName+ ", ");
            }
            logger.log(Level.INFO, " Callflow: Handlers :" +sb.toString() );
        }
    }
    
    public Handler[] getHandlers (){
        Handler[] h = handlers.values().toArray (new Handler[0]);
        return h;
    }
    
    public void removeHandler (String name){
        if(traceOn){
            logger.log(Level.INFO, " Callflow:Removing Handler :" +name );        
        }
        handlers.remove(name);
    }
}
