/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * RequestEndAccessObjectImpl.java
 *
 * Created on July 13, 2005, 6:36 PM
 */

package com.sun.enterprise.admin.monitor.callflow;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import com.sun.enterprise.admin.monitor.callflow.TableInfo;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import com.sun.enterprise.admin.common.constant.AdminConstants;
/**
 *
 * @author Harpreet Singh
 */
public class RequestEndAccessObjectImpl extends AbstractTableAccessObject{
    private static final Logger logger =
            Logger.getLogger(AdminConstants.kLoggerName);

    private static RequestEndAccessObjectImpl _singletonRE;
    
    /** Creates a new instance of RequestEndAccessObjectImpl */
    private RequestEndAccessObjectImpl() {
        String serverName = super.getServerInstanceName();
        super.tableName = TableInfo.REQUEST_END_TABLE_NAME +
                serverName.toUpperCase();
        super.setName ("RequestEnd");        
    }

    public boolean dropTable(Connection connection) {        
        super.con = connection;        
        return super.createStatmentAndExecuteUpdate(
                TableInfo.DROP_TABLE_REQUEST_END_SQL,
                TableInfo.REQUEST_END_TABLE_NAME);        
    }
    public boolean createTable (Connection connection){
        super.con = connection;       
        return super.createTable(
                TableInfo.CREATE_TABLE_REQUEST_END_SQL, 
                TableInfo.REQUEST_END_TABLE_NAME);
    }    
   
    public static TableAccessObject getInstance() {
        if(_singletonRE == null)
            _singletonRE = new RequestEndAccessObjectImpl ();
        
        return _singletonRE;
    }    

    public boolean insert(java.sql.PreparedStatement pstmt, TransferObject[] transferObject) {
        // sanity
        if (pstmt == null)
            return false;

        boolean result = false;
        try{
            for (int i = 0 ; i<transferObject.length; i++) {
                RequestEndTO request = (RequestEndTO)transferObject[i];
                pstmt.setString(1, request.getRequestId());
                pstmt.setLong(2, request.getTimeStamp());
                pstmt.addBatch();
            }
            int[] updated = pstmt.executeBatch();
            result =  (updated.length == transferObject.length)? true : false;
            addTotalEntriesProcessed(updated.length);
            
            if (isTraceOn()){
                logger.log(Level.INFO, "Callflow: RequestEndAccessObjectImpl " +
                        " Attempting to Insert : " + transferObject.length +
                        " Inserted "+updated.length+ " rows." +
                        " Total Entries written so far : "+ 
                        getTotalEntriesProcessed());
            }
            
        }  catch(BatchUpdateException bue) {
            // log it
            logger.log(Level.FINE, "Error inserting data into CallFlow tables", bue);
            result = false;
        }catch (SQLException se) {
            // log it
            logger.log(Level.FINE, "Error inserting data into CallFlow tables", se);
            result = false;
        }
        return result;
    }

    public String getInsertSQL() {
        String newsql = super.updateSqlWithTableName(
                TableInfo.INSERT_INTO_TABLE_REQUEST_END_SQL, 
                TableInfo.REQUEST_END_TABLE_NAME);
        return newsql;        
    }

    public String getDeleteSQL () {
        String newsql = super.updateSqlWithTableName (
                TableInfo.DELETE_FROM_TABLE_REQUEST_END_SQL,
                TableInfo.REQUEST_END_TABLE_NAME);
        return newsql;
    }

    
}
