/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * TableAccessObject.java
 *
 * Created on July 11, 2005, 11:14 AM
 */

package com.sun.enterprise.admin.monitor.callflow;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

/**
 *
 * Represents access to a single table. 
 * Allows for Create, Drop and Updates to tables
 * @author Harpreet Singh
 */
public interface TableAccessObject {
    
    public boolean createTable(Connection connection);
    public boolean dropTable(Connection connection);

    public boolean insert(PreparedStatement pstmt, TransferObject[] transferObject);

    public String getInsertSQL();

    public String getDeleteSQL ();

    public String getServerInstanceName ();
    
    /**
     * delete a list of request ids from the table
     */
    public boolean delete (PreparedStatement pstmt, String[] requestId);
    
    public String getName ();
    public long getTotalEntriesProcessed();
}
