<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:template match="applications">
    <xsl:copy>
      <xsl:copy-of select="node()|@*"/>
      <xsl:element name="mbean">
        <xsl:attribute name="enabled">false</xsl:attribute>
        <xsl:attribute name="impl-class-name">com.sun.enterprise.ee.selfmanagement.actions.JdbcPoolMgmtAction</xsl:attribute>
        <xsl:attribute name="name">JdbcPoolMgmtAction</xsl:attribute>
        <xsl:attribute name="object-name">system:impl-class-name=com.sun.enterprise.ee.selfmanagement.actions.JdbcPoolMgmtAction,category=self-management</xsl:attribute>
        <xsl:attribute name="object-type">system-all</xsl:attribute>
        <xsl:element name="property">
            <xsl:attribute name="name">PoolNames</xsl:attribute>
            <xsl:attribute name="value">jdbc-pool=30</xsl:attribute>
        </xsl:element>
        <xsl:element name="property">
            <xsl:attribute name="name">SampleInterval</xsl:attribute>
            <xsl:attribute name="value">30</xsl:attribute>
        </xsl:element>
      </xsl:element> 
      <xsl:element name="mbean">
        <xsl:attribute name="enabled">false</xsl:attribute>
        <xsl:attribute name="impl-class-name">com.sun.enterprise.ee.selfmanagement.actions.LowMemoryAlertAction</xsl:attribute>
        <xsl:attribute name="name">LowMemoryAlertAction</xsl:attribute>
        <xsl:attribute name="object-name">system:impl-class-name=com.sun.enterprise.ee.selfmanagement.actions.LowMemoryAlertAction,scategory=self-management</xsl:attribute>
        <xsl:attribute name="object-type">system-all</xsl:attribute>
        <xsl:element name="property">
            <xsl:attribute name="name">Threshold</xsl:attribute>
            <xsl:attribute name="value">80</xsl:attribute>
        </xsl:element>
        <xsl:element name="property">
            <xsl:attribute name="name">Offset</xsl:attribute>
            <xsl:attribute name="value">0</xsl:attribute>
        </xsl:element>
        <xsl:element name="property">
            <xsl:attribute name="name">MemoryPoolNames</xsl:attribute>
            <xsl:attribute name="value">Perm Gen, Tenured Gen</xsl:attribute>
        </xsl:element>
        <xsl:element name="property">
            <xsl:attribute name="name">MailRecipients</xsl:attribute>
            <xsl:attribute name="value">user@localhost</xsl:attribute>
        </xsl:element>
        <xsl:element name="property">
            <xsl:attribute name="name">MailResource</xsl:attribute>
            <xsl:attribute name="value">mail-res-1</xsl:attribute>
        </xsl:element>
      </xsl:element> 
      <xsl:element name="mbean">
        <xsl:attribute name="enabled">false</xsl:attribute>
        <xsl:attribute name="impl-class-name">com.sun.enterprise.ee.selfmanagement.actions.DeadQueueMessageAlertAction</xsl:attribute>
        <xsl:attribute name="name">DeadQueueMessageAlertAction</xsl:attribute>
        <xsl:attribute name="object-name">system:impl-class-name=com.sun.enterprise.ee.selfmanagement.actions.DeadQueueMessageAlertAction,scategory=self-management</xsl:attribute>
        <xsl:attribute name="object-type">system-all</xsl:attribute>
        <xsl:element name="property">
            <xsl:attribute name="name">Threshold</xsl:attribute>
            <xsl:attribute name="value">1</xsl:attribute>
        </xsl:element>
        <xsl:element name="property">
            <xsl:attribute name="name">Offset</xsl:attribute>
            <xsl:attribute name="value">0</xsl:attribute>
        </xsl:element>
        <xsl:element name="property">
            <xsl:attribute name="name">Interval</xsl:attribute>
            <xsl:attribute name="value">120</xsl:attribute>
        </xsl:element>
        <xsl:element name="property">
            <xsl:attribute name="name">MailRecipients</xsl:attribute>
            <xsl:attribute name="value">user@localhost</xsl:attribute>
        </xsl:element>
        <xsl:element name="property">
            <xsl:attribute name="name">MailResource</xsl:attribute>
            <xsl:attribute name="value">mail-res-1</xsl:attribute>
        </xsl:element>
      </xsl:element> 
      <xsl:element name="mbean">
        <xsl:attribute name="enabled">false</xsl:attribute>
        <xsl:attribute name="impl-class-name">com.sun.enterprise.ee.selfmanagement.actions.ThreadHangAction</xsl:attribute>
        <xsl:attribute name="name">ThreadHangAction</xsl:attribute>
        <xsl:attribute name="object-name">system:impl-class-name=com.sun.enterprise.ee.selfmanagement.actions.ThreadHangAction,scategory=self-management</xsl:attribute>
        <xsl:attribute name="object-type">system-all</xsl:attribute>
        <xsl:element name="property">
            <xsl:attribute name="name">ThresholdWait</xsl:attribute>
            <xsl:attribute name="value">80000</xsl:attribute>
        </xsl:element>
        <xsl:element name="property">
            <xsl:attribute name="name">StopThread</xsl:attribute>
            <xsl:attribute name="value">false</xsl:attribute>
        </xsl:element>
        <xsl:element name="property">
            <xsl:attribute name="name">MailAlertAppRef</xsl:attribute>
            <xsl:attribute name="value">MailAlert</xsl:attribute>
        </xsl:element>
      </xsl:element> 
      <xsl:element name="mbean">
        <xsl:attribute name="enabled">false</xsl:attribute>
        <xsl:attribute name="impl-class-name">com.sun.enterprise.ee.selfmanagement.actions.InstanceHangAction</xsl:attribute>
        <xsl:attribute name="name">InstanceHangAction</xsl:attribute>
        <xsl:attribute name="object-name">system:impl-class-name=com.sun.enterprise.ee.selfmanagement.actions.InstanceHangAction,scategory=self-management</xsl:attribute>
        <xsl:attribute name="object-type">system-all</xsl:attribute>
        <xsl:element name="property">
            <xsl:attribute name="name">TimeoutInSeconds</xsl:attribute>
            <xsl:attribute name="value">10</xsl:attribute>
        </xsl:element>
        <xsl:element name="property">
            <xsl:attribute name="name">Restart</xsl:attribute>
            <xsl:attribute name="value">true</xsl:attribute>
        </xsl:element>
      </xsl:element> 
      <xsl:element name="mbean">
        <xsl:attribute name="enabled">false</xsl:attribute>
        <xsl:attribute name="impl-class-name">com.sun.enterprise.ee.selfmanagement.actions.MailAlert</xsl:attribute>
        <xsl:attribute name="name">MailAlert</xsl:attribute>
        <xsl:attribute name="object-name">system:impl-class-name=com.sun.enterprise.ee.selfmanagement.actions.MailAlert,scategory=self-management</xsl:attribute>
        <xsl:attribute name="object-type">system-all</xsl:attribute>
        <xsl:element name="property">
            <xsl:attribute name="name">Recipients</xsl:attribute>
            <xsl:attribute name="value">user@localhost</xsl:attribute>
        </xsl:element>
        <xsl:element name="property">
            <xsl:attribute name="name">MailResource</xsl:attribute>
            <xsl:attribute name="value">mail-res-1</xsl:attribute>
        </xsl:element>
      </xsl:element> 
      <xsl:element name="mbean">
        <xsl:attribute name="enabled">false</xsl:attribute>
        <xsl:attribute name="impl-class-name">com.sun.enterprise.ee.selfmanagement.mbeans.DiskToolKit</xsl:attribute>
        <xsl:attribute name="name">DiskToolKit</xsl:attribute>
        <xsl:attribute name="object-name">system:impl-class-name=com.sun.enterprise.ee.selfmanagement.actions.DiskToolKit,scategory=self-management</xsl:attribute>
        <xsl:attribute name="object-type">system-all</xsl:attribute>
        <xsl:element name="property">
            <xsl:attribute name="name">PartitionSpace</xsl:attribute>
            <xsl:attribute name="value">${com.sun.aas.instanceRoot}/logs</xsl:attribute>
        </xsl:element>
      </xsl:element> 
      <xsl:element name="mbean">
        <xsl:attribute name="enabled">false</xsl:attribute>
        <xsl:attribute name="impl-class-name">com.sun.enterprise.ee.selfmanagement.actions.DiskAction</xsl:attribute>
        <xsl:attribute name="name">LogCleanupAction</xsl:attribute>
        <xsl:attribute name="object-name">system:impl-class-name=com.sun.enterprise.ee.selfmanagement.actions.DiskAction,scategory=self-management</xsl:attribute>
        <xsl:attribute name="object-type">system-all</xsl:attribute>
        <xsl:element name="property">
            <xsl:attribute name="name">ServerLogFilter</xsl:attribute>
            <xsl:attribute name="value">true</xsl:attribute>
        </xsl:element>
        <xsl:element name="property">
            <xsl:attribute name="name">AsadminAccessLogFilter</xsl:attribute>
            <xsl:attribute name="value">false</xsl:attribute>
        </xsl:element>
        <xsl:element name="property">
            <xsl:attribute name="name">ServerAccessLogFilter</xsl:attribute>
            <xsl:attribute name="value">false</xsl:attribute>
        </xsl:element>
      </xsl:element> 
    </xsl:copy>
  </xsl:template>

  <xsl:template match="management-rules">
    <xsl:copy>
      <xsl:copy-of select="node()|@*"/>
      <xsl:element name="management-rule">
        <xsl:attribute name="enabled">false</xsl:attribute>
        <xsl:attribute name="name">JdbcConnectionPoolMgmtRule</xsl:attribute>
        <xsl:element name="event">
            <xsl:attribute name="level">FINE</xsl:attribute>
            <xsl:attribute name="record-event">false</xsl:attribute>
            <xsl:attribute name="type">lifecycle</xsl:attribute>
            <xsl:element name="property">
                <xsl:attribute name="name">name</xsl:attribute>
                <xsl:attribute name="value">ready</xsl:attribute>
            </xsl:element> 
        </xsl:element> 
        <xsl:element name="action">
        <xsl:attribute name="action-mbean-name">JdbcPoolMgmtAction</xsl:attribute>
        </xsl:element> 
        <xsl:element name="description">
        Management rule to auto tune connection pool attributes
        </xsl:element> 
      </xsl:element> 
      <xsl:element name="management-rule">
        <xsl:attribute name="enabled">false</xsl:attribute>
        <xsl:attribute name="name">DeadQueueMessageAlertRule</xsl:attribute>
        <xsl:element name="event">
            <xsl:attribute name="level">FINE</xsl:attribute>
            <xsl:attribute name="record-event">false</xsl:attribute>
            <xsl:attribute name="type">lifecycle</xsl:attribute>
            <xsl:element name="property">
                <xsl:attribute name="name">name</xsl:attribute>
                <xsl:attribute name="value">ready</xsl:attribute>
            </xsl:element> 
        </xsl:element> 
        <xsl:element name="action">
        <xsl:attribute name="action-mbean-name">DeadQueueMessageAlertAction</xsl:attribute>
        </xsl:element> 
        <xsl:element name="description">Management rule to send an alert in case of a dead message</xsl:element> 
      </xsl:element> 
      <xsl:element name="management-rule">
        <xsl:attribute name="enabled">false</xsl:attribute>
        <xsl:attribute name="name">LowMemoryAlertRule</xsl:attribute>
        <xsl:element name="event">
            <xsl:attribute name="level">FINE</xsl:attribute>
            <xsl:attribute name="record-event">false</xsl:attribute>
            <xsl:attribute name="type">lifecycle</xsl:attribute>
            <xsl:element name="property">
                <xsl:attribute name="name">name</xsl:attribute>
                <xsl:attribute name="value">ready</xsl:attribute>
            </xsl:element> 
        </xsl:element> 
        <xsl:element name="action">
        <xsl:attribute name="action-mbean-name">LowMemoryAlertAction</xsl:attribute>
        </xsl:element> 
        <xsl:element name="description">Management rule to send an alert in case of a low memory</xsl:element> 
      </xsl:element> 
      <xsl:element name="management-rule">
        <xsl:attribute name="enabled">false</xsl:attribute>
        <xsl:attribute name="name">ThreadHangDetectionRule</xsl:attribute>
        <xsl:element name="event">
            <xsl:attribute name="level">FINE</xsl:attribute>
            <xsl:attribute name="record-event">false</xsl:attribute>
            <xsl:attribute name="type">timer</xsl:attribute>
            <xsl:element name="property">
                <xsl:attribute name="name">period</xsl:attribute>
                <xsl:attribute name="value">60000</xsl:attribute>
            </xsl:element> 
        </xsl:element> 
        <xsl:element name="action">
        <xsl:attribute name="action-mbean-name">ThreadHangAction</xsl:attribute>
        </xsl:element> 
        <xsl:element name="description">Management Rule to detect thread hang and send an aler</xsl:element> 
      </xsl:element> 
      <xsl:element name="management-rule">
        <xsl:attribute name="enabled">false</xsl:attribute>
        <xsl:attribute name="name">InstanceHangDetectionRule</xsl:attribute>
        <xsl:element name="event">
            <xsl:attribute name="level">FINE</xsl:attribute>
            <xsl:attribute name="record-event">false</xsl:attribute>
            <xsl:attribute name="type">timer</xsl:attribute>
            <xsl:element name="property">
                <xsl:attribute name="name">period</xsl:attribute>
                <xsl:attribute name="value">60000</xsl:attribute>
            </xsl:element> 
        </xsl:element> 
        <xsl:element name="action">
        <xsl:attribute name="action-mbean-name">InstanceHangAction</xsl:attribute>
        </xsl:element> 
        <xsl:element name="description">Management Rule detect instance hang</xsl:element> 
      </xsl:element> 
      <xsl:element name="management-rule">
        <xsl:attribute name="enabled">false</xsl:attribute>
        <xsl:attribute name="name">LogCleanupRule</xsl:attribute>
        <xsl:element name="event">
            <xsl:attribute name="level">FINE</xsl:attribute>
            <xsl:attribute name="record-event">false</xsl:attribute>
            <xsl:attribute name="type">monitor</xsl:attribute>
            <xsl:element name="property">
                <xsl:attribute name="name">monitortype</xsl:attribute>
                <xsl:attribute name="value">countermonitor</xsl:attribute>
            </xsl:element> 
            <xsl:element name="property">
                <xsl:attribute name="name">initthreshold</xsl:attribute>
                <xsl:attribute name="value">0</xsl:attribute>
            </xsl:element> 
            <xsl:element name="property">
                <xsl:attribute name="name">numbertype</xsl:attribute>
                <xsl:attribute name="value">long</xsl:attribute>
            </xsl:element> 
            <xsl:element name="property">
                <xsl:attribute name="name">observedmbean</xsl:attribute>
                <xsl:attribute name="value">DiskToolKit</xsl:attribute>
            </xsl:element> 
            <xsl:element name="property">
                <xsl:attribute name="name">observedattribute</xsl:attribute>
                <xsl:attribute name="value">DiskFree</xsl:attribute>
            </xsl:element> 
        </xsl:element> 
        <xsl:element name="action">
        <xsl:attribute name="action-mbean-name">LogCleanupAction</xsl:attribute>
        </xsl:element> 
        <xsl:element name="description">Management Rule to periodic log cleanup</xsl:element> 
      </xsl:element> 
    </xsl:copy>
  </xsl:template>

  <xsl:template match="application-ref[@ref='admingui']">
     <xsl:copy>
      <xsl:apply-templates select="@*"/>
     </xsl:copy>
    <xsl:text>
    <application-ref enabled="false" ref="LogCleanupAction"/>
    <application-ref enabled="false" ref="JdbcPoolMgmtAction"/>
    <application-ref enabled="false" ref="LowMemoryAlertAction"/>
    <application-ref enabled="false" ref="DeadQueueMessageAlertAction"/>
    <application-ref enabled="false" ref="ThreadHangAction"/>
    <application-ref enabled="false" ref="InstanceHangAction"/>
    <application-ref enabled="false" ref="MailAlert"/>
    <application-ref enabled="false" ref="DiskToolKit"/>
    </xsl:text>
  </xsl:template>
</xsl:stylesheet>
