/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.admin.wsmgmt;

import javax.xml.ws.handler.MessageContext;
import javax.xml.soap.SOAPMessage;
import java.util.Iterator;
import java.util.Set;
import java.util.Map;

/**
 * SOAP Message Context. This encapsulates the required data for web services
 * management either from JAXWS 1.0 or 2.0 MessageContext.
 */
public class SOAPMessageContext_2_0 implements SOAPMessageContext {

    /**
     * Constructed from JAXWS 2.0 MessageContext
     *
     * @param   msg    the detail message for this exception
     */
    public SOAPMessageContext_2_0(
        com.sun.enterprise.webservice.SOAPMessageContext smc) {
        if (smc == null) {
            throw new IllegalArgumentException();
        }
        _smc = smc;
    }

    /**
     * Gets the SOAPMessage for this web service invocation.
     *
     * @return  SOAPMessage for this web service invocation
     */
    public SOAPMessage getMessage() {
        return _smc.getMessage();
    }

    /**
     * Gets the PropertyNames for this web service invocation.
     *
     * @return  PropertyNames for this web service invocation
     */
    public Iterator getPropertyNames() {
        Set keySet = _smc.keySet();
        if ( keySet != null) {
            return keySet.iterator();
        } else {
            return null;
        }
    }

    /**
     * Gets the PropertyNames for this web service invocation.
     *
     * @return  PropertyNames for this web service invocation
     */
    public Object getProperty(String name) {
        // convert jax-rpc property to jax ws property
        if (( name != null) && (
        "com.sun.xml.rpc.server.http.HttpServletRequest".equals(name))) {
            name = MessageContext.SERVLET_REQUEST;
        }
        return _smc.get(name);
    }

    /**
     * Sets the SOAPMessage in the message context.
     *
     * @param msg the SOAPMessage to be set in the message context
     */
    public void setMessage(SOAPMessage msg) {
            _smc.setMessage(msg);
    }
    /**
     * Gets the HTTP Request headers in the message.
     *
     * @return the HTTP Request headers in the message.
     */
    public String getHTTPRequestHeaders() {
        Map headerMap = (Map)_smc.get(MessageContext.HTTP_REQUEST_HEADERS);
        return Utils.getString(headerMap);
    }

    /**
     * Gets the HTTP Response headers in the message.
     *
     * @return the HTTP Response headers in the message.
     */
    public String getHTTPResponseHeaders() {
        Map headerMap = (Map)_smc.get(MessageContext.HTTP_RESPONSE_HEADERS);
        return Utils.getString(headerMap);
    }

    // Private variables
    private com.sun.enterprise.webservice.SOAPMessageContext _smc = null;
}
