/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.admin.wsmgmt.filter.spi;

import java.util.List;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.Iterator;
import java.util.Map;
import java.util.HashMap;

/**
 * This class interacts with JAX RPC Monitoring SPI and registers Global
 * Listener to get callbacks. 
 */
public class FilterRegistry {

    public synchronized void registerFilter(String stage, String endpoint, 
        Filter filter) {

        List fl = (List) filters.get( stage + DELIM + endpoint);
        if ( fl == null ) {
            fl = new ArrayList();
        }
        fl.add(filter);
        filters.put(stage + DELIM + endpoint, fl); 
        setManaged(endpoint);
    }

    public void unregisterFilter(String stage, String endpoint, Filter filter) {
        List fl = (List) filters.get( stage + DELIM + endpoint);
        if ( fl == null ) {
            throw new IllegalArgumentException(" No registration exists for " +
                stage + DELIM + endpoint );
        }
        fl.remove(fl.indexOf(filter));
        if ( filters.isEmpty() ) {
            // this is the last filter, set this web service as un-managed
            setUnManaged(endpoint);
        }
    }

    public void unregisterFilterByName(String stage, String endpoint, 
        String filtername) {

        List fl = (List) filters.get( stage + DELIM + endpoint);
        if ( fl == null ) {
            throw new IllegalArgumentException(" No registration exists for " +
                stage + DELIM + endpoint );
        }
        Iterator fli = fl.iterator();
        while (fli.hasNext()) {
            Filter f = (Filter) fli.next();
            if (f.getName().equals(filtername)) {
                fli.remove();
                continue;
            }
        }

        if ( filters.isEmpty() ) {
            // this is the last filter, set this web service as un-managed
            setUnManaged(endpoint);
        }
    }

    public void unregisterAllFilters(String endpoint) {
        Iterator itr = filters.keySet().iterator();
        while ( itr.hasNext()) {
            String key = (String) itr.next();
            if ( key.contains( DELIM+endpoint) ) {
                itr.remove();
            }
        }
    }

    public List getFilters(String stage, String endpoint) {
        return (List) filters.get(stage + DELIM + endpoint);
    }

    // Is this method needed???
    public FilterRegistration[] getFilters(String endpoint) {
        return null;
    }

    public boolean isManaged(String endpoint) {
        if ( managedEndpoints == null)
            return false;
        else {
             Object o = managedEndpoints.get(endpoint);
             if ( o != null) {
                return true;
             } else {
                return false;
             }
        }
    }

    public void setManaged(String endpoint) {
        managedEndpoints.put(endpoint, Boolean.valueOf(true));
    }

    public void setUnManaged(String endpoint) {
        managedEndpoints.remove(endpoint);
    }

    public static synchronized FilterRegistry getInstance() {
        if ( fm == null) {
            fm = new FilterRegistry();
        }
        if ( managedEndpoints == null ) {
            managedEndpoints = new HashMap();
        }
        if ( filters == null ) {
            filters = new HashMap();
        }
        return fm;
    }

    private static FilterRegistry fm = null;

    private FilterRegistry() {}

    private static HashMap managedEndpoints = null;

    private static HashMap filters = null;

    public static final String DELIM = ":";
}
