/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.admin.wsmgmt.repository;

import com.sun.enterprise.admin.wsmgmt.repository.spi.RepositoryException;
import com.sun.enterprise.admin.wsmgmt.repository.spi.WebServiceInfoProvider;
import com.sun.enterprise.admin.wsmgmt.repository.spi.WebServiceInfo;
import com.sun.enterprise.tools.common.AppServWebServiceInfoProvider;
import com.sun.enterprise.config.serverbeans.Domain;

import junit.framework.TestCase;
import junit.framework.TestResult;
import junit.framework.TestSuite;

import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.Iterator;

public class WebServiceInfoProviderTest extends TestCase {
   
    public WebServiceInfoProviderTest(String name) {
        super(name);        
    }       

    public void testWSInfos() throws RepositoryException {                        
        try {
           Map map = new HashMap();
           map.put( WebServiceInfoProvider.MOD_TYPE_PROP_NAME, "WEB");
           map.put( WebServiceInfoProvider.WS_XML_LOCATION_PROP_NAME, 
                    WS_XML_FILE);
           map.put( WebServiceInfoProvider.APP_ID_PROP_NAME, "jaxrpc-simple");
           map.put( WebServiceInfoProvider.BUNDLE_NAME_PROP_NAME, 
                    "jaxrpc-simple.war");
           List list  = impl.getWebServiceInfo(WEB_XML_FILE, map); 
           Iterator hItr = list.iterator();
           while ( hItr.hasNext() ) {
                Object m = hItr.next();
                System.out.println(" Web Service Info " + m.toString());
           }
        } catch (RepositoryException re) {
            re.printStackTrace();
            throw re;
        }
    }

  
    protected void setUp() {
        impl = new AppServWebServiceInfoProvider();
    }

    private final static String EJB_XML_FILE = 
                    "/tmp/com/sun/enterprise/admin/wsmgmt/sun-ejb-jar.xml";
    private final static String WEB_XML_FILE = 
                    "/tmp/com/sun/enterprise/admin/wsmgmt/sun-web.xml";
    private final static String WS_XML_FILE = 
                    "/tmp/com/sun/enterprise/admin/wsmgmt/webservices.xml";

    private AppServWebServiceInfoProvider impl = null;

    public static void main(String args[]) {
        junit.textui.TestRunner.run(WebServiceInfoProviderTest.class);
    }
}
