/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.deployment.annotation.impl;

import java.io.File;
import java.io.IOException;
import java.util.Set;
import java.util.Iterator;
import java.util.Enumeration;
import java.util.HashSet;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.jar.JarFile;
import java.util.jar.JarEntry;
import com.sun.enterprise.deployment.annotation.Scanner;

/**
 * Implements the scanner interface on a jar file.
 *
 * @author Jerome Dochez
 */
public class JarScanner extends JavaEEScanner implements Scanner {
    
    File jarFile;
    Set<JarEntry> entries = new HashSet<JarEntry>();
    ClassLoader classLoader = null;
    
    /** Creates a new instance of JarScanner */
    public JarScanner(File jarFile) throws IOException {
        this.jarFile = jarFile;
        init();
    }
    
    private void init() throws java.io.IOException {
        JarFile jf = new JarFile(jarFile);
        
        Enumeration<JarEntry> entriesEnum = jf.entries();
        while(entriesEnum.hasMoreElements()) {
            JarEntry je = entriesEnum.nextElement();
            if (je.getName().endsWith(".class")) {
                entries.add(je);
            }
        }        
    }    
    
    public ClassLoader getClassLoader() {
        if (classLoader==null) {
            URL[] urls = new URL[1];
            try {
                urls[0] = jarFile.getAbsoluteFile().toURL();
                classLoader = new URLClassLoader(urls);
            } catch(Exception e) {
                e.printStackTrace();
            }
        }
        return classLoader;
    }
    
    public Set<Class> getElements() {
        
        
        Set<Class> elements = new HashSet<Class>();
        if (getClassLoader()==null) {
            AnnotationUtils.getLogger().severe("Class loader null");
            return elements;
        }        
        for (JarEntry je : entries) {
            String fileName = je.getName();
            // convert to a class name...
            String className = fileName.replace(File.separatorChar, '.');
            className = className.substring(0, className.length()-6);
            try {                
                elements.add(classLoader.loadClass(className));
                
            } catch(ClassNotFoundException cnfe) {
                cnfe.printStackTrace();
            }
        }
        return elements;
    }
    
    
}
