/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.appserv.addons;

/**
 * AddonFatalException indicates that the Addon has failed to execute the 
 * operation, and that will affect appserver. For example, if this
 * exception is thrown during installation, appserver cannot continue with
 * the installation.
 */
public class AddonFatalException extends AddonException {

    /**
     * Constructs an <code>AddonFatalException</code> object with null reason;
     */
    public AddonFatalException() {
    }

    /**
     * Constructs an <code>AddonFatalException</code> object with a reason;
     *
     * @param reason a description of the exception
     */
    public AddonFatalException(String reason) {
        super(reason);
    }

    /**
     * Constructs an <code>AddonFatalException</code> object with a cause.
     *
     * @param cause cause of the exception.
     */
    public AddonFatalException(Throwable cause) {
        super(cause);
    }

    /**
     * Constructs an <code>AddonFatalException</code> object with a reason and
     * and cause.
     *
     * @param reason a description of the exception
     * @param cause cause of the exception.
     */
    public AddonFatalException(String reason, Throwable cause) {
        super(reason, cause);
    }

}
