/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.appserv.addons;

/**
 * AddonVersion object represents the version 
 * in terms of major, minor and patch level.
 * <p>
 * For ex.
 * am_components_installer_01_02_03.jar or am_components_configurator_01_02_03.jar
 * <p>
 * If no version is present in the name, it'll be assumed that 
 * the major is 00, minor is 00 and patch level is 00.
 * <p>
 * This class provides methods to get the components of version 
 * major, minor and patch level as int and the full version as string
 * ex. 01_02_03
 *
 * @author Sreenivas Munnangi
 * @since 9.1
 */
public interface AddonVersion {

    /**
     * Get the full version as string, for example.
     * If the addon is named as am_components_installer_01_02_03.jar
     * then the version output will be "01_02_03" in String format.
     * @return String version
     */
    public String getVersion() throws AddonException;

    /**
     * Get the majr version, for example.
     * If the addon is named as am_components_installer_01_02_03.jar
     * then the value of 1 will be returned.
     * @return int major
     */
    public int getMajor() throws AddonException;

    /**
     * Get the minor version, for example.
     * If the addon is named as am_components_installer_01_02_03.jar
     * then the value of 2 will be returned.
     * @return int minor
     */
    public int getMinor() throws AddonException;

    /**
     * Get the patch version, for example.
     * If the addon is named as am_components_installer_01_02_03.jar
     * then the value of 3 will be returned.
     * @return int patch
     */
    public int getPatch() throws AddonException;

}
