/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.appserv.addons;

import java.io.File;
import com.sun.appserv.management.DomainRoot;

/**
 * A context class describing the context in which Configurator is being
 * executed. 
 *
 * @see com.sun.appserv.addons.InstallationContext
 */
public class ConfigurationContext {

    /**
     * <p>DAS         - Configurator is being executed to configure DAS.
     * <p>INSTANCE    - Configurator is being executed in DAS to configure 
     *                  an instance 
     */
    public enum ConfigurationType {DAS, INSTANCE}

    private InstallationContext ic = null;
    private File domainDir = null;
    private ConfigurationType type = null;
    private DomainRoot domainRoot = null;

    /**
     * Set an instance of <code>InstallationContext</code> 
     *
     * @param ic <code>InstallationContext</code>
     */
    public void setInstallationContext(InstallationContext ic) {
        this.ic = ic;
    }
     
    /**
     * Provide an instance of <code>InstallationContext</code>
     *
     * @return <code>InstallationContext</code>
     */
    public InstallationContext getInstallationContext() {
        return this.ic;
    }

    /**
     * Set the location of domain. 
     *
     * @param domain <code>java.io.File</code> object
     */
    public void setDomainDirectory(File domain) {
        this.domainDir = domain;   
    }

    /**
     * Return the location of domain. Will be null, when the 
     * <code>ConfigurationType</code> is REMOTEINSTANCE 
     *
     * @return <code>java.io.File</code> object
     */
    public File getDomainDirectory() {
        return this.domainDir;
    }

    /**
     * Set the configuration type.
     *
     * @param type DAS or INSTANCE.
     */
    public void setConfigurationType(ConfigurationType type) {
        this.type = type;
    }

    /**
     * Return the <code>ConfigurationType</code>
     *
     * @return <code>ConfigurationType</code>
     */
    public ConfigurationType getConfigurationType() {
        return this.type;
    }

    /**
     * Set the AMX <code>DomainRoot</code> object.
     * This will be set only when <code>ConfigurationType</code>
     * is INSTANCE.
     *
     * @param root DomainRoot.
     */
    public void setAMXDomainRoot(DomainRoot root) {
        this.domainRoot = root;
    }

    /**
     * Return the <code>DomainRoot</code> object. When 
     * <code>ConfigurationType</code> is DAS this object 
     * will return null.
     * When <code>ConfigurationType</code> is INSTANCE
     * this method will return a valid <code>DomainRoot</code>
     * object. Any domain.xml updates at the time of 
     * <code>Configurator.configureInstances</code> should be 
     * done using AMX.
     *
     * @retun a <code>DomainRoot</code> object or null.
     */
    public DomainRoot getAMXDomainRoot() {
        return domainRoot;
    }

}
