/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.jbi.serviceengine;

import javax.management.MBeanException;
import javax.management.RuntimeMBeanException;
import javax.management.RuntimeOperationsException;

/**
 *
 * @author Manisha Umbarje
 */
public class ServiceEngineException extends Exception {
    
    /** Creates a new instance of ServiceEngineException */
    public ServiceEngineException(String message) {
        super(message);
    }
    
    public ServiceEngineException(Throwable e) {
        super(e);
    }
    public static ServiceEngineException filterExceptions( Exception jmxEx )
    {
        Throwable rootCause = jmxEx;
        Throwable cause = rootCause;
        for (;;)
        {
            if ( cause == null ||
            !( cause instanceof MBeanException  ||
            cause instanceof RuntimeMBeanException ||
            cause instanceof RuntimeOperationsException ) ) {
                break;
            }
            rootCause = cause.getCause();
            cause = rootCause;
        }
        if ( rootCause instanceof ServiceEngineException ){
            return (ServiceEngineException) rootCause;
        } else {
            return new ServiceEngineException(rootCause);
        }
    }
}
