/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.jbi.serviceengine.install;
import com.sun.enterprise.admin.common.MBeanServerFactory;
import javax.management.MBeanServerConnection;



/**
 *
 * @author Manisha Umbarje
 */
public class ServiceEngineObjectFactoryImpl 
        implements ServiceEngineObjectFactory {
    
    private static ServiceEngineObjectFactoryImpl factoryObj = 
            new ServiceEngineObjectFactoryImpl();
    private Installer installer;
    private MBeanHelper helper;
    
    /** Creates a new instance of ServiceEngineObjectFactory */
    private ServiceEngineObjectFactoryImpl() {
    }
    
    
    public static ServiceEngineObjectFactoryImpl getInstance()  {
        return factoryObj;
    }
     
    public Installer createInstaller() {
        if (installer == null)
            installer = new InstallerImpl(createMBeanHelper());
        return installer;
    }
    
    public MBeanHelper createMBeanHelper() {
        if(helper == null) {
            helper = new MBeanHelper(createMBeanServerConnection());
        }
        return helper;
    }
    public MBeanServerConnection createMBeanServerConnection() {
        try {
           return MBeanServerFactory .getMBeanServer();
        } catch(Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}
