/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.addons;

import java.io.File;
import java.net.URL;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.BufferedReader;
import java.util.logging.Logger;
import java.util.logging.Level;
import com.sun.appserv.addons.AddonFatalException;
import com.sun.enterprise.addons.util.JarFileFilter;
import com.sun.enterprise.util.OS;

/**
 * Utility class that computes the classpath setting
 * for the addon. Classpath is 
 * AS_HOME/lib/*.jar;AS_HOME/lib/ant/lib/*.jar
 *
 * @since 9.1
 * @author binod@dev.java.net
 */
class AddonClassPath {

    private static final String CONFIG = "config";
    private static final String ASENVCONF = "asenv.conf";
    private static final String ASENVBAT = "asenv.bat";
    private static final String ASANTREGEX = "(AS_ANT_LIB=)";
    private static Logger logger = null;

    static URL[] getClassPath(URL jar, String installRoot, Logger logr) 
    throws AddonFatalException {
        logger = logr;
        File asLib = new File (installRoot + File.separator + "lib");
        File antLib = getAntLib(installRoot);

        File[] asLibJars = asLib.listFiles(new JarFileFilter());
        File[] antLibJars = antLib.listFiles(new JarFileFilter());

        URL[] urls = new URL[asLibJars.length + antLibJars.length+1];
        int i = 0;
        try {
            for (File asLibJar : asLibJars ) {
                urls[i] = asLibJar.toURI().toURL();
                i++;
            }

            for (File antLibJar : antLibJars ) {
                urls[i] = antLibJar.toURI().toURL();
                i++;
            }
        } catch (Exception e) {
            throw new AddonFatalException(e);
        }

        urls[i] = jar;
        return urls;
    }


    private static boolean isUnix() {
        return OS.isUnix();
    }


    private static File getAntLib(String installDir) throws AddonFatalException{
        BufferedReader bf = null;
        FileInputStream in = null;
        try {
            String asenv="";
            if(isUnix()) {
                asenv = installDir + File.separator + CONFIG + File.separator + 
                        ASENVCONF;
            } else {
                asenv = installDir + File.separator + CONFIG + File.separator + 
                        ASENVBAT;
            }
        
            logger.log(Level.FINER, asenv);

            in = new FileInputStream(asenv);
            String antLib = "";
            bf = new BufferedReader(new InputStreamReader(in));
            String line = bf.readLine();
            while(line != null) {
                logger.log(Level.FINER,line);
                String[] asantLine = line.split(ASANTREGEX);
                if (asantLine.length > 1) {
                    if (isUnix()) {
                       asantLine = asantLine[1].split("\"");
                    } 
                    antLib = asantLine[1];
                    logger.log(Level.FINER,"antLib "+antLib);
                    return new File(antLib);
                }
                line = bf.readLine();
             }
             return null;
        }catch(Exception e) {
            logger.log(Level.SEVERE,e.getMessage(), e);
            throw new AddonFatalException(e);
        } finally {
            try {
                if(bf != null)  
                    bf.close();
                if(in != null)
                    in.close();  
            } catch (Exception e) {
                logger.log(Level.WARNING,e.getMessage(), e);
            }
        }
    }
}
