/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.addons;

import java.io.File;
import java.util.logging.Logger;
import com.sun.appserv.addons.AddonFatalException;

/**
 * Facade class that will be used by any client for
 * Addon runtime.
 * 
 * @since 9.1
 * @author binod@dev.java.net
 */
public class AddonFacade {

    /**
     * Install a single addon jar file. This is called from 
     * asadmin install-addon command.
     */ 
    public static void install
    (File installDir, File jarFile, Logger logr ) throws AddonFatalException {
        AddonInstallationController aic =
        AddonController.getAddonInstallationController();
        aic.setLogger(logr);
        aic.install(installDir, jarFile);
    }

    /**
     * Install all jar files. This is called from 
     * appserver installer.
     */ 
    public static void install
    (File installDir, Logger logr ) throws AddonFatalException {
        AddonInstallationController aic =
        AddonController.getAddonInstallationController();
        aic.setLogger(logr);
        aic.install(installDir);
    }

    /**
     * Uninstall a single addon . This is called from 
     * asadmin uninstall-addon command.
     */ 
    public static void uninstall
    (File installDir, String addon, Logger logr ) throws AddonFatalException {
        AddonInstallationController aic =
        AddonController.getAddonInstallationController();
        aic.setLogger(logr);
        aic.uninstall(installDir, addon);
    }

    /**
     * Uninstall all addons. This is called from 
     * appserver uninstaller.
     */ 
    public static void uninstall
    (File installDir, Logger logr ) throws AddonFatalException {
        AddonInstallationController aic =
        AddonController.getAddonInstallationController();
        aic.setLogger(logr);
        aic.uninstall(installDir);
    }


    /**
     * Install all jar files. This is called from 
     * asadmin start-domain.
     */
    public static void configureDAS
    (File installDir, File domainDir, Logger logr) throws AddonFatalException {
        AddonConfigurationController acc = 
        AddonController.getAddonConfigurationController();
        acc.setLogger(logr);
        acc.configureDAS(installDir, domainDir);
    }

    /**
     * Install all jar files. This is called from 
     * asadmin start-instances.
     */
    public static void configureInstances
    (File installDir, File domainDir, Logger logr) throws AddonFatalException {
        AddonConfigurationController acc = 
        AddonController.getAddonConfigurationController();
        acc.setLogger(logr);
        acc.configureInstances(installDir, domainDir);
    }

    /**
     * Unconfigure the components from DAS.
     * This is called from asadmin stop-domain.
     */
    public static void unconfigureDAS
    (File installDir, File domainDir, Logger logr) throws AddonFatalException {
        AddonConfigurationController acc = 
        AddonController.getAddonConfigurationController();
        acc.setLogger(logr);
        acc.unconfigureDAS(installDir, domainDir);
    }

}
