/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.addons;

import java.io.*;
import java.util.*;
import java.util.logging.Logger;
import java.util.logging.Level;
import com.sun.appserv.addons.AddonFatalException;
import com.sun.appserv.addons.ConfigurationContext;

/**
 * This class maintains the registry, it is a warpper over Properties class.
 * @author binod@dev.java.net
 */
public class AddonInstanceRegistry extends AddonRegistry{

    
    protected AddonInstanceRegistry(File domainRoot, Logger logger) 
    throws AddonFatalException {
        super(domainRoot, logger);
    }
    
    /**
     * Retrieve the current status of the addon.
     * If the addon does not exist in the registry, then 
     * it should be configured.
     * If the addon status is changed to enabled/disabled
     * that is figured out by comparing with the system copy. 
     * of the registry.
     * If the addon is marked for unconfiguring, the addon 
     * status will be "unconfigure".
     * If the status is same in user copy and system copy
     * the status will be "unchanged"
     */
    protected status getStatus(String name){

        String systemConfFlag = 
        String.class.cast(systemRegistry.get(name+INSTANCEKEY+CONFIGUREKEY));

        if (systemConfFlag != null && systemConfFlag.equals("true")) {
            return status.CONFIGURE;
        }

        if (systemConfFlag != null && systemConfFlag.equals("false")) {
            return status.UNCONFIGURE;
        }

        return status.UNCHANGED;
    }


    /**
     * Change the status. It will make the status the same in 
     * user copy of the registry and system copy.
     */
    protected void setStatus(String name, status stat) {
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, 
            "[No Op]Setting status of " + name + " as" + stat);
        }
    }
    
}
