/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.jbi.serviceengine.bridge;
import com.sun.enterprise.jbi.serviceengine.ServiceEngineException;
import com.sun.enterprise.jbi.serviceengine.core.EndpointRegistry;
import com.sun.enterprise.jbi.serviceengine.core.ServiceEngineEndpoint;
import java.util.Hashtable;
import java.util.Map;
import javax.xml.namespace.QName;



/**
 * Endpoint Name to JAXWS RuntimeEndpointInfo mapping
 * @author Manisha Umbarje
 */
public class RuntimeEndpointInfoRegistryImpl implements
        RuntimeEndpointInfoRegistry {
    
    private Hashtable store;
    private static RuntimeEndpointInfoRegistry registry = new RuntimeEndpointInfoRegistryImpl();
    private EndpointRegistry endpointRegistry = null;

    /** Creates a new instance of RuntimeEndpointInfoRegistry */
    private RuntimeEndpointInfoRegistryImpl() {
        store = new Hashtable(5);
        endpointRegistry = EndpointRegistry.getInstance();
    }
    
    public static RuntimeEndpointInfoRegistry getInstance() {
        return registry;
    }

    /** This method is used only for JAX-RPC invocation. */
    public Object getRuntimeEndpointInfo(QName service, String endpoint)
    throws ServiceEngineException {
        ServiceEngineEndpoint endpt = endpointRegistry.get(service,  endpoint);
      
        if(endpt != null) {
            Map runtimeEndpointInfoTable = (Map)store.get(service);
            if(runtimeEndpointInfoTable == null) {
                runtimeEndpointInfoTable = new Hashtable();
                store.put(service, runtimeEndpointInfoTable);
            }
            
            Object runtimeInfo = runtimeEndpointInfoTable.get(endpoint);
      
            if(runtimeInfo == null) {
                runtimeInfo = JAXRPCRuntimeEndpointHelper.populateRuntimeInfo(endpt);
                runtimeEndpointInfoTable.put(endpoint, runtimeInfo);
            }
            return runtimeInfo;
        }
        throw new ServiceEngineException("Endpoint " +  endpoint + "not deployed in JBI");
    }
    
    public void deleteRuntimeEndpointInfo(QName service, String endpoint)   {
        
        if(endpoint != null) {
            Map runtimeInfoTable = (Map)store.get(service);
            
            if((runtimeInfoTable != null) &&
                    (runtimeInfoTable.get(endpoint) != null))
                runtimeInfoTable.remove(endpoint);
        }
    }
    
    
}
