/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.jbi.serviceengine.bridge.transport;

import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.pipe.Pipe;
import com.sun.xml.ws.api.pipe.PipeCloner;
import com.sun.xml.ws.api.pipe.helper.AbstractPipeImpl;

import javax.xml.namespace.QName;
import java.net.URL;

/**
 * This is the main Pipe that is used by JAX-WS client runtime to sendRequest the 
 * request to the service and return the response back to the client.
 *  
 * 
 * @author Vikas Awasthi
 */
public class JBITransportPipe extends AbstractPipeImpl {

    //private Codec codec;
    private URL wsdlLocation;
    private QName service;
    private WSDLPort wsdlPort;

    public JBITransportPipe(WSBinding binding, 
                            URL wsdlLocation, 
                            QName service, 
                            WSDLPort wsdlPort) {
        /*
        StreamSOAPCodec xmlEnvCodec =
            Codecs.createSOAPEnvelopeXmlCodec(binding.getSOAPVersion());
        codec = Codecs.createSOAPBindingCodec(binding, xmlEnvCodec);
         */
        this.wsdlLocation = wsdlLocation;
        this.service = service;
        this.wsdlPort = wsdlPort;
    }

    private JBITransportPipe(Pipe that, PipeCloner cloner) {
        super(that, cloner);
    }

    public Packet process(Packet request) {
        try {
            // TODO get the oneway flag from the message
//            Boolean isOneway = request.getMessage().isOneWay(wSDLPort);
            boolean isOneWay = !request.expectReply;
            
            QName operation = request.getMessage().getOperation(wsdlPort).getName();
            String endpointName = wsdlPort.getName().getLocalPart();
            NMRClientConnection con =
                    new NMRClientConnection(wsdlLocation, service, endpointName, operation, isOneWay);

            con.initialize();
            con.sendRequest(request.getMessage());
            
            if(isOneWay) {    
                return request.createResponse(null);    // one way. no response given.
            }
            
            //String contentType = ct.getContentType();
            Message respMsg = con.receiveResponse();
            Packet reply = request.createResponse(respMsg);
            con.sendStatus();
            /*
            InputStream response = con.getInput();
            codec.decode(response, contentType, reply);
             */

            return reply;
        } catch(Exception wex) {
            throw new RuntimeException(wex);
        } 
    }

    public Pipe copy(PipeCloner cloner) {
        return new JBITransportPipe(this, cloner);
    }
}
