/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.jbi.serviceengine.bridge.transport;
import com.sun.enterprise.jbi.serviceengine.comm.MessageExchangeTransport;
import com.sun.enterprise.jbi.serviceengine.comm.MessageExchangeTransportFactory;
import com.sun.enterprise.jbi.serviceengine.core.ServiceEngineEndpoint;
import com.sun.logging.LogDomains;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.server.WebServiceContextDelegate;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.server.WSEndpoint;
import java.security.Principal;
import java.util.logging.Logger;
import javax.jbi.messaging.MessageExchange;

/**
 *
 * @author Manisha Umbarje
 */
public class NMRServerConnection implements WebServiceContextDelegate {
    
    private MessageExchange me;
    private ServiceEngineEndpoint endpt;
    private MessageExchangeTransport meTransport;
    
    private static Logger logger =
            LogDomains.getLogger(LogDomains.SERVER_LOGGER);
    
    /** Creates a new instance of NMRServerConnection */
    public NMRServerConnection(MessageExchange messageExchange,
            ServiceEngineEndpoint endpt) {
        this.me = messageExchange;
        this.endpt = endpt;
        meTransport = MessageExchangeTransportFactory.getHandler(me);
    }
    
    public Message receiveRequest() {
        return meTransport.receive(endpt.getEndpointMetaData());
    }
    
    public void sendResponse(Message abstractMessage) {
        meTransport.send(abstractMessage, endpt.getEndpointMetaData());
    }
    
    public void handleException(Exception e) {
        meTransport.sendError(e);
    }
    
    //TODO: Implement these methods
    public Principal getUserPrincipal(Packet request) {
        return null;
    }
    
    public boolean isUserInRole(Packet request, String role) {
        return false;
    }
    
    public String getEPRAddress(Packet request, WSEndpoint endpoint) {
        return null;
    }
    
    public String getWSDLAddress(Packet request, WSEndpoint endpoint) {
        return null;
    }
}
