/*
 * MessageExchangeTransportFactory.java
 *
 * Created on November 16, 2006, 12:15 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package com.sun.enterprise.jbi.serviceengine.comm;

import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.InOut;
import javax.jbi.messaging.MessageExchange;

/**
 *
 * This class handles creating an appropriate Message Exchange Handler.
 *
 * Currently we support only InOnly and InOut message exchange patterns.
 *
 * @author bhavanishankar@dev.java.net
 */

public class MessageExchangeTransportFactory {
    
    private static Logger logger =
            LogDomains.getLogger(LogDomains.SERVER_LOGGER);
    
    public static MessageExchangeTransport getHandler(MessageExchange me) {
        
        MessageExchangeTransport handler;
        
        if(me instanceof InOut) {
            handler =
                    me.getRole().equals(MessageExchange.Role.PROVIDER)
                    ? new ProviderInOut((InOut)me)
                    : new ConsumerInOut((InOut)me);
        } else if (me instanceof InOnly) {
            handler =
                    me.getRole().equals(MessageExchange.Role.PROVIDER)
                    ? new ProviderInOnly((InOnly)me)
                    : new ConsumerInOnly((InOnly)me);
        } else { // Currently we don't support for other types of MEP.
            handler = null;
        }
        
	    if(logger.isLoggable(Level.FINE)) {	
        	logger.log(Level.FINE, "Handler = " + handler);
		}
        
        return handler;
    }
}
