/*
 * MessageExchangeTransportImpl.java
 *
 * Created on November 16, 2006, 7:29 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package com.sun.enterprise.jbi.serviceengine.comm;

import com.sun.enterprise.jbi.serviceengine.ServiceEngineException;
import com.sun.enterprise.jbi.serviceengine.handlers.JBIHandler;
import com.sun.enterprise.jbi.serviceengine.handlers.JBIHandlerFactory;
import com.sun.logging.LogDomains;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;

/**
 *
 * @author bhavanishankar@dev.java.net
 */
public abstract class MessageExchangeTransportImpl
        implements MessageExchangeTransport {

    MessageExchange me;
    protected NormalizedMessage msg = null;
    protected static Logger logger =
            LogDomains.getLogger(LogDomains.SERVER_LOGGER);

    protected MessageExchangeTransportImpl(MessageExchange me) {
        this.me = me;
    }

    public void sendStatus(ExchangeStatus status) {
        try {
            me.setStatus(status);
            MessageSender messageSender = new MessageSender();
            messageSender.setMessageExchange(me);
            messageSender.send();
        } catch(Exception ex) {
            // Can't do much here.
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    public void sendError(Exception exception) {
        try {
            if(exception != null) {
                me.setError(exception);
            }
            me.setStatus(ExchangeStatus.ERROR);
            send();
        } catch(Exception ex) {
            // Can't do much here.
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    public MessageExchange getMessageExchange() {
        return me;
    }

    public NormalizedMessage getMessage() {
        return msg;
    }

    protected void send() throws Exception {
        preSend();
        MessageSender messageSender = new MessageSender();
        messageSender.setMessageExchange(me);
        messageSender.send();
        Exception exception = messageSender.getException();
        if(exception != null)
            throw exception;
    }

    public Exception receiveError() {
        preReceive();
        return me.getError();
    }

    protected String extractFaultCode(String completeFaultCode) {
        StringTokenizer tokenizer = new StringTokenizer(completeFaultCode, ":");
        if(tokenizer.countTokens() > 1) tokenizer.nextToken();
        return tokenizer.nextToken();
    }

    protected void preReceive() {
        invokeHandlersForOutbound();
    }

    protected void preSend() throws Exception {
        invokeHandlersForInbound();
    }

    // Before calling the handlers ensure that the msg is set in this 
    // MessageExchangeTransport
    protected void invokeHandlersForInbound() throws ServiceEngineException {
        for (JBIHandler handler : JBIHandlerFactory.getInstance().getHandlers())
            try {
            handler.handleInbound(this);
        } catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            throw new ServiceEngineException(e);
        }
    }

    protected void invokeHandlersForOutbound() {
        for (JBIHandler handler : JBIHandlerFactory.getInstance().getHandlers())
            try {
            handler.handleOutbound(this);
        } catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            // throw new ServiceEngineException(e);
        }
    }
}
