/*
 * InOnlyMEPHandler.java
 *
 * Created on November 16, 2006, 12:18 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package com.sun.enterprise.jbi.serviceengine.comm;

import com.sun.enterprise.jbi.serviceengine.util.soap.EndpointMetaData;
import com.sun.xml.ws.api.message.Message;
import java.util.logging.Level;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.NormalizedMessage;

/**
 *
 * This class handles sending message to & receiving message from NMR when
 *
 *  1) Role of the component is Provider.
 *  2) Message exchange pattern is In-Only.
 *
 * @author bhavanishankar@dev.java.net
 */

public class ProviderInOnly extends MessageExchangeTransportImpl  {
    
    protected InOnly me;
    
    public ProviderInOnly(InOnly me) {
        super(me);
        this.me = me;
    }
    
    public NormalizedMessage receiveNormalized() {
        msg = me.getInMessage();
        preReceive();
        return msg;
    }
    
    public UnWrappedMessage receive(EndpointMetaData emd) {
        NormalizedMessage normalizedMessage = receiveNormalized();
        UnWrappedMessage unwrappedMessage = null;
        if(normalizedMessage != null) {
            try {
                unwrappedMessage = new UnWrappedMessage(
                        normalizedMessage,
                        me.getOperation().getLocalPart(),
                        emd,
                        false
                        );
            } catch(Exception ex) {
                logger.log(Level.INFO, ex.getMessage());
            }
        }
        return unwrappedMessage;
    }
        
    public void send(NormalizedMessage response) {
        try {
            me.setStatus(ExchangeStatus.DONE);
            send();
        } catch(Exception ex) {
            sendError(ex);
        }
    }

    public void send(Message abstractMessage, EndpointMetaData emd) {
        send(null);
    }
    
}
