/*
 * InOutMEPHandler.java
 *
 * Created on November 16, 2006, 12:16 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package com.sun.enterprise.jbi.serviceengine.comm;

import com.sun.enterprise.jbi.serviceengine.util.soap.EndpointMetaData;
import com.sun.xml.ws.api.message.Message;
import java.util.logging.Level;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.InOut;
import javax.jbi.messaging.NormalizedMessage;

/**
 *
 * This class handles sending message to & receiving message from NMR when
 *
 *  1) Role of the component is Provider.
 *  2) Message exchange pattern is In-Out.
 *
 * @author bhavanishankar@dev.java.net
 */
public class ProviderInOut extends MessageExchangeTransportImpl {
    
    private InOut me;
    
    public ProviderInOut(InOut me) {
        super(me);
        this.me = me;
    }
    
    public NormalizedMessage receiveNormalized() {
        msg = me.getInMessage();
        preReceive();
        return msg;
    }
    
    public UnWrappedMessage receive(EndpointMetaData emd) {
        NormalizedMessage normalizedMessage = receiveNormalized();
        UnWrappedMessage unwrappedMessage = null;
        if(normalizedMessage != null) {
            try {
                unwrappedMessage = new UnWrappedMessage(
                        normalizedMessage,
                        me.getOperation().getLocalPart(),
                        emd,
                        false
                        );
            } catch(Exception ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
                // TODO : Should we send error/fault to client???
            }
        }
        return unwrappedMessage;
    }
    
    public void send(NormalizedMessage response) {
        try {
            if(response instanceof Fault) {
                me.setFault((Fault)response);
            } else {
                me.setOutMessage(response);
            }
            this.msg = response;
            send();
        } catch(Exception ex) {
            sendError(ex);
        }
    }
    
    public void send(Message message, EndpointMetaData emd) {
        try {
            WrappedMessage wrappedMessage = new WrappedMessage(message,
                    me.getOperation().getLocalPart(),
                    emd,
                    true
                    );
            NormalizedMessage normalizedMessage = wrappedMessage.isFault() ?
                me.createFault() : me.createMessage();
            normalizedMessage.setContent(wrappedMessage.readPayloadAsSource());
            send(normalizedMessage);
        } catch(Exception ex) {
            ex.printStackTrace();
        }
    }
    
    /*
     
    public void send(ByteArrayOutputStream output, int status) {
        if(output == null) {
            sendError((String)null);
        } else if(status == SOAPConstants.JBI_ERROR) {
            sendError(output.toString());
        } else {
            send(createMessage(output, status));
        }
    }
     
    private NormalizedMessage createMessage(ByteArrayOutputStream output, int status) {
        try {
            byte[] message = ((ByteArrayOutputStream)output).toByteArray();
            if(logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Response message = " + new String(message));
            }
            NormalizedMessage response = null;
            if(status == SOAPConstants.JBI_FAULT) {
                ByteArrayInputStream is = new ByteArrayInputStream(message);
                response = me.createFault();
                Document n = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(is);
                response.setContent(new DOMSource(n));
                try {
                    String faultString = n.getElementsByTagName("faultstring").item(0).getTextContent();
                    String faultCode = n.getElementsByTagName("faultcode").item(0).getTextContent();
                    if(logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "FaultCode = " + faultCode + ", FaultString = " + faultString);
                    }
                    response.setProperty(SOAPConstants.FAULT_STRING_PROPERTY_NAME, faultString);
                    response.setProperty(SOAPConstants.FAULT_CODE_PROPERTY_NAME, extractFaultCode(faultCode));
                } catch(Exception ex) {
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                }
            } else {
                ByteArrayInputStream is = new ByteArrayInputStream(message);
                response = me.createMessage();
                response.setContent(new StreamSource(is));
            }
            return response;
        } catch(Exception ex) {
            return null;
        }
    }
     */
    
}
