/*
 * WrappedMessage.java
 *
 * Created on November 20, 2006, 6:03 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package com.sun.enterprise.jbi.serviceengine.comm;

import com.sun.enterprise.jbi.serviceengine.core.JavaEEServiceEngineContext;
import com.sun.enterprise.jbi.serviceengine.util.DOMUtil;
import com.sun.enterprise.jbi.serviceengine.util.JBIConstants;
import com.sun.enterprise.jbi.serviceengine.util.soap.EndpointMetaData;
import com.sun.enterprise.jbi.serviceengine.util.soap.SOAPConstants;
import com.sun.logging.LogDomains;
import com.sun.xml.bind.api.Bridge;
import com.sun.xml.ws.api.message.HeaderList;
import com.sun.xml.ws.api.message.Message;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wsdl.Part;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

/**
 *
 * @author bhavani
 */
public class WrappedMessage extends Message
        implements JBIConstants, SOAPConstants {
    
    private static Logger logger =
            LogDomains.getLogger(LogDomains.SERVER_LOGGER);
    
    /**
     * Holds the contents of the wrapped message.
     */
    Source wrappedMessage;
    Message abstractMessage;
    
    /** Creates a new instance of WrappedMessage */
    public WrappedMessage(
            Message abstractMessage,
            String operationName,
            EndpointMetaData emd,
            boolean isResponse) throws Exception {
        
        this.abstractMessage = abstractMessage;
        
        if(JavaEEServiceEngineContext.getInstance().isServiceMix()) {
            logger.log(Level.FINE, "Skipping the wrapping...");
            wrappedMessage = abstractMessage.readPayloadAsSource();
            return;
        }
        
        String bindingStyle = emd.getBindingStyle(operationName);
        logger.log(Level.FINE, "WrappedMessage :: bindingStyle = " + bindingStyle
                + ", operationName = " + operationName
                );
        
        QName wrappedMessageType = isResponse
                ? emd.getOutputMessage(operationName).getQName()
                : emd.getInputMessage(operationName).getQName();
        
        String wrappedMessageName = isResponse
                ? emd.getOperationOutputName(operationName)
                : emd.getOperationInputName(operationName);
        
        //StreamSource ss = getStreamSource(src);
        if(RPC_STYLE.equalsIgnoreCase(bindingStyle)) {
            javax.wsdl.Message message = isResponse
                    ? emd.getOutputMessage(operationName)
                    : emd.getInputMessage(operationName);
            List<Part> orderedParts = message.getOrderedParts(null);
            new RPCStyleWrapper().
                    wrap(abstractMessage, wrappedMessageName,
                    wrappedMessageType, orderedParts);
        } else {
            new DocumentStyleWrapper().
                    wrap(abstractMessage, wrappedMessageName, wrappedMessageType);
        }
    }
    
    class DocumentStyleWrapper {
        void wrap(Message abstractMessage,
                String wrappedMessageName,
                QName wrappedMessageType) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                XMLStreamWriter writer = XMLOutputFactory.newInstance().createXMLStreamWriter(baos);
                writer.writeStartDocument();
                if (abstractMessage.isFault()) { // there is no need to wrap fault.
                    //abstractMessage.writePayloadTo(writer);
                    writePayloadTo(writer);
                } else {
                    writer.writeStartElement(WRAPPER_MESSAGE_QNAME);
                    writeMessageAttributes(writer, wrappedMessageName, wrappedMessageType);
                    writer.writeStartElement(WRAPPER_PART_QNAME); // assuming only one part in the response.
                    writer.writeCharacters(""); // Force completion of open elems
                    //abstractMessage.writePayloadTo(writer);
                    writePayloadTo(writer);
                    writer.writeEndElement();
                    writer.writeEndElement();
                }
                writer.writeEndDocument();
                writer.flush();
                if(logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "\n\nWrapped message = " + baos.toString() + "\n\n");
                }
                ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
                String usedWith = System.getProperty(USED_WITH);
                if(usedWith != null && usedWith.indexOf(USED_WITH_HTTP_SOAP_BC) != -1) {
                    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                    factory.setNamespaceAware(true);
                    wrappedMessage = new DOMSource(factory.newDocumentBuilder().parse(bais));
                } else {
                    wrappedMessage = new StreamSource(bais);
                }
            } catch(Exception ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
        
    }
    
    class RPCStyleWrapper {
        
        void wrap(Message abstractMessage,
                String wrappedMessageName,
                QName wrappedMessageType,
                List<Part> parts
                ) throws Exception {
            
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                XMLStreamWriter writer = XMLOutputFactory.newInstance().createXMLStreamWriter(baos);
                writer.writeStartDocument();
                if (abstractMessage.isFault()) { // there is no need to wrap fault.
                    //abstractMessage.writePayloadTo(writer);
                    writePayloadTo(writer);
                } else {
                    writer.writeStartElement(WRAPPER_MESSAGE_QNAME);
                    writeMessageAttributes(writer, wrappedMessageName, wrappedMessageType);
                    XMLStreamReader payLoad = abstractMessage.readPayload();
                    if(payLoad.getEventType() == XMLStreamReader.START_DOCUMENT) {
                        payLoad.next();
                    }
                    Map<String,String> payLoadNSAttrs = new HashMap<String,String>();
                    copyNamespaceAttributes(payLoad, payLoadNSAttrs);
                    writeJBIParts(payLoad, writer, parts, payLoadNSAttrs);
                    writer.writeEndElement();
                }
                writer.writeEndDocument();
                writer.flush();
                if(logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "\n\nWrapped message = " + baos.toString() + "\n\n");
                }
                ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
                String usedWith = System.getProperty(USED_WITH);
                if(usedWith != null && usedWith.indexOf(USED_WITH_HTTP_SOAP_BC) != -1) {
                    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                    factory.setNamespaceAware(true);
                    wrappedMessage = new DOMSource(factory.newDocumentBuilder().parse(bais));
                } else {
                    wrappedMessage = new StreamSource(bais);
                }
            } catch(Exception ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
        
        private void copyNamespaceAttributes(
                XMLStreamReader reader,
                Map<String,String> m) throws Exception {
            for(int i=0; i<reader.getNamespaceCount(); i++) {
                m.put(reader.getNamespacePrefix(i),
                        reader.getNamespaceURI(i));
            }
        }
        
        private void writeJBIParts(
                XMLStreamReader reader, 
                XMLStreamWriter writer, 
                List<Part> parts, 
                Map<String,String> ancestorNamespaceAttrs) throws Exception {
            int partIndex = 0;
            boolean done = false;
            String rootNodeName =
                    (reader.getPrefix() != null && reader.getPrefix().length() != 0)
                    ? reader.getPrefix() + ":" + reader.getLocalName()
                    : reader.getLocalName();
            while(reader.hasNext() && !done) {
                int event = reader.next();
                if(event == XMLStreamReader.END_ELEMENT) {
                    String elementName =
                            (reader.getPrefix() != null && reader.getPrefix().length() != 0)
                            ? reader.getPrefix() + ":" + reader.getLocalName()
                            : reader.getLocalName();
                    if(elementName.equals(rootNodeName)) {
                        done = true;
                        break;
                    }
                }
                if(parts.get(partIndex).getName().equals(reader.getLocalName())) {
                    writer.writeStartElement(WRAPPER_PART_QNAME);
                    //if(isSimpleType(parts.get(partIndex))) {
                    DOMUtil.UTIL.writeChildren(reader, writer, ancestorNamespaceAttrs);
                    //} else {
                    //    DOMUtil.UTIL.writeNode(reader, writer);
                    //}
                    writer.writeEndElement();
                    ++partIndex;
                }
            }
        }
        
        private boolean isSimpleType(Part part) {
            QName parttype = part.getTypeName();
            if (parttype != null) {
                String s = parttype.getNamespaceURI();
                if ( s != null && s.trim().equals("http://www.w3.org/2001/XMLSchema")) {
                    return true;
                }
            }
            return false;
        }
        
    }
    
    private void writeMessageAttributes(XMLStreamWriter sw,
            String wrappedMessageName,
            QName wrappedMessageType) throws XMLStreamException {
        String prefix = wrappedMessageType.getPrefix();
        if (prefix == null || prefix.trim().length() == 0) {
            prefix = "msgns";
        }
        sw.writeAttribute(WRAPPER_ATTRIBUTE_VERSION, WRAPPER_ATTRIBUTE_VERSION_VALUE);
        if(wrappedMessageName != null) {
            sw.writeAttribute(WRAPPER_ATTRIBUTE_NAME, wrappedMessageName);
        }
        sw.writeAttribute(WRAPPER_ATTRIBUTE_TYPE, prefix + ":" + wrappedMessageType.getLocalPart());
        sw.writeAttribute("xmlns:" + prefix, wrappedMessageType.getNamespaceURI());
        sw.writeAttribute("xmlns:" + WRAPPER_DEFAULT_NAMESPACE_PREFIX, WRAPPER_DEFAULT_NAMESPACE);
    }
    
    public Source readPayloadAsSource() {
        return wrappedMessage;
    }
    
    public boolean isFault() {
        return abstractMessage.isFault();
    }
    
    public String getPayloadLocalPart() {
        return abstractMessage.getPayloadLocalPart();
    }
    
    public String getPayloadNamespaceURI() {
        return abstractMessage.getPayloadNamespaceURI();
    }
    
    public XMLStreamReader readPayload() throws XMLStreamException {
        return abstractMessage.readPayload();
    }
    
    public boolean hasPayload() {
        return abstractMessage.hasPayload();
    }
    
    public boolean hasHeaders() {
        return abstractMessage.hasHeaders();
    }
    
    public HeaderList getHeaders() {
        return abstractMessage.getHeaders();
    }
    
    public Message copy() {
        return null;
    }
    
    public Source readEnvelopeAsSource() {
        return abstractMessage.readEnvelopeAsSource();
    }
    
    public SOAPMessage readAsSOAPMessage() throws SOAPException {
        return abstractMessage.readAsSOAPMessage();
    }
    
    public <T> T readPayloadAsJAXB(Unmarshaller unmarshaller) throws JAXBException {
        return (T) abstractMessage.readPayloadAsJAXB(unmarshaller);
    }
    
    public <T> T readPayloadAsJAXB(Bridge<T> bridge) throws JAXBException {
        return abstractMessage.readPayloadAsJAXB(bridge);
    }
    
    public void writePayloadTo(XMLStreamWriter sw) throws XMLStreamException {
        /* *
         * Fix for CR 6505270, 6505328
         * Read the payLoad and write it instead of abstractMessage.writePayLoadTo(sw).
         */
        try {
            DOMUtil.UTIL.writeNode(abstractMessage.readPayload(), sw);
        } catch(Exception ex) {
            ex.printStackTrace();
            throw new XMLStreamException(ex);
        }
    }
    
    public void writeTo(ContentHandler contentHandler, ErrorHandler errorHandler) throws SAXException {
        abstractMessage.writeTo(contentHandler, errorHandler);
    }
    
    /**
     * Writes the wrapped abstractMessage into the stream writer.
     *
     * The fault is not wrapped to compensate a bug in HTTP SOAP BC.
     * It is assumed that the normal response abstractMessage has only one part.
     */
    public void writeTo(XMLStreamWriter sw) throws XMLStreamException {
        writePayloadTo(sw);
    }
    
}
